<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'officer') {
  header("Location: ../auth/login.php");
  exit;
}

$officer_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? 'Officer';

$stmt = $pdo->prepare("SELECT * FROM employment_terms WHERE officer_id = ? ORDER BY id DESC");
$stmt->execute([$officer_id]);
$terms = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>My Employment Terms</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css" rel="stylesheet">
  <style>
    body { background-color: #f8fafd; font-family: 'Segoe UI', sans-serif; }
    .container { max-width: 900px; }
  </style>
</head>
<body>

<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="text-primary">📄 My Employment Terms</h4>
    <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">← Back to Dashboard</a>
  </div>

  <?php if (empty($terms)): ?>
    <div class="alert alert-info">No employment terms uploaded yet.</div>
  <?php else: ?>
    <div class="table-responsive">
      <table id="termTable" class="table table-bordered table-hover">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Position</th>
            <th>Period</th>
            <th>Contract File</th>
            <th>Uploaded</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($terms as $i => $t): ?>
            <tr>
              <td><?= $i + 1 ?></td>
              <td><?= htmlspecialchars($t['position']) ?></td>
              <td><?= $t['start_date'] ?> → <?= $t['end_date'] ?></td>
              <td>
                <?php if (!empty($t['contract_file'])): ?>
                  <a href="../uploads/kets/<?= $t['contract_file'] ?>" target="_blank" class="btn btn-sm btn-outline-info">📄 View PDF</a>
                <?php else: ?>
                  <span class="text-muted">N/A</span>
                <?php endif; ?>
              </td>
              <td><?= date('d M Y', strtotime($t['created_at'] ?? $t['start_date'])) ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

<script>
  $(document).ready(function () {
    $('#termTable').DataTable({
      dom: 'Bfrtip',
      buttons: ['excelHtml5', 'print'],
      order: [[4, 'desc']]
    });
  });
</script>

</body>
</html>
