<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'officer') {
  header("Location: ../auth/login.php");
  exit;
}

$officer_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? 'Officer';
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Apply for Leave</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background-color:rgb(206, 221, 241);
      font-family: 'Segoe UI', sans-serif;
    }
    .container {
      max-width: 960px;
    }
    .badge-warning {
      background-color: #ffc107;
    }
    .badge-success {
      background-color: #28a745;
    }
    .badge-danger {
      background-color: #dc3545;
    }
  </style>
</head>
<body>

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="text-primary mb-4">📤 Apply for Leave</h4>
        <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">← Back to Dashboard</a>
    </div>
    <div class="card">
        <div class="card-body">
          
            <form method="POST" action="leave_submit.php">
                <div class="mb-3">
                <label for="leave_type" class="form-label">Leave Type</label>
                <select name="leave_type" id="leave_type" class="form-select" required>
                    <option value="">-- Select --</option>
                    <option value="annual">Annual Leave</option>
                    <option value="medical">Medical Leave</option>
                    <option value="hospital">Hospital Leave</option>
                    <option value="unpaid">Unpaid Leave</option>
                </select>
                </div>

                <div class="row mb-3">
                <div class="col">
                    <label for="start_date" class="form-label">Start Date</label>
                    <input type="date" name="start_date" id="start_date" class="form-control" required>
                </div>
                <div class="col">
                    <label for="end_date" class="form-label">End Date</label>
                    <input type="date" name="end_date" id="end_date" class="form-control" required>
                </div>
                </div>

                <div class="mb-3">
                <label for="reason" class="form-label">Reason</label>
                <input type="text" name="reason" id="reason" class="form-control" placeholder="Short reason for leave..." required>
                </div>

                <button class="btn btn-outline-primary w-100">Submit Request</button>
                <div class="text-center mt-3">
                </div>
            </form>
        </div>
    </div>
</div>

</body>
</html>
