<?php
session_start();
require_once '../includes/config.php';

if (!isset($_GET['id'])) {
    die("Missing incident ID.");
}

$id = (int)$_GET['id'];

$stmt = $pdo->prepare("SELECT * FROM incident_reports WHERE id = ?");
$stmt->execute([$id]);
$incident = $stmt->fetch();

if (!$incident) {
    die("Incident not found.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $subject = $_POST['subject'] ?? '';
    $informant = $_POST['informant_name'] ?? '';
    $contact = $_POST['contact_no'] ?? '';
    $officer = $_POST['recording_officer'] ?? '';
    $status = $_POST['status'] ?? 'pending';

    $update = $pdo->prepare("UPDATE incident_reports SET
        subject = :subject,
        informant_name = :informant,
        contact_no = :contact,
        recording_officer = :officer,
        status = :status,
        updated_at = NOW()
        WHERE id = :id
    ");

    $update->execute([
        ':subject' => $subject,
        ':informant' => $informant,
        ':contact' => $contact,
        ':officer' => $officer,
        ':status' => $status,
        ':id' => $id
    ]);

    $_SESSION['toast'] = ['message' => '✅ Report updated.'];
    header("Location: view_incidents.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <title>Edit Incident</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
  <h3>Edit Incident Report: <?= htmlspecialchars($incident['report_number']) ?></h3>
  <form method="POST">
    <div class="mb-3">
      <label class="form-label">Subject</label>
      <input type="text" name="subject" value="<?= htmlspecialchars($incident['subject']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Informant Name</label>
      <input type="text" name="informant_name" value="<?= htmlspecialchars($incident['informant_name']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Contact No</label>
      <input type="text" name="contact_no" value="<?= htmlspecialchars($incident['contact_no']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Recording Officer</label>
      <input type="text" name="recording_officer" value="<?= htmlspecialchars($incident['recording_officer']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Status</label>
      <select name="status" class="form-select">
        <option value="pending" <?= $incident['status'] === 'pending' ? 'selected' : '' ?>>Pending</option>
        <option value="approved" <?= $incident['status'] === 'approved' ? 'selected' : '' ?>>Approved</option>
        <option value="rejected" <?= $incident['status'] === 'rejected' ? 'selected' : '' ?>>Rejected</option>
      </select>
    </div>
    <button type="submit" class="btn btn-success">Save Changes</button>
    <a href="view_incidents.php" class="btn btn-secondary">Cancel</a>
  </form>
</div>
</body>
</html>
