<?php
session_start();
require_once '../includes/config.php';

// Access control (optional but recommended)
if (!isset($_SESSION['role']) || !in_array($_SESSION['role'], ['admin', 'controller'])) {
    die("Access denied.");
}

// Validate ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid or missing incident ID.");
}

$id = (int)$_GET['id'];

// Optionally: check existence before delete
$stmt = $pdo->prepare("SELECT id FROM incident_reports WHERE id = ?");
$stmt->execute([$id]);

if (!$stmt->fetch()) {
    $_SESSION['toast'] = ['message' => '❌ Incident not found.'];
    header("Location: view_incidents.php");
    exit;
}

// Proceed to delete
$delete = $pdo->prepare("DELETE FROM incident_reports WHERE id = ?");
$delete->execute([$id]);

$_SESSION['toast'] = ['message' => '🗑️ Incident deleted successfully.'];
header("Location: view_incidents.php");
exit;
?>
