<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'controller') {
  header("Location: ../auth/login.php");
  exit;
}

$today = date('Y-m-d');

// Fetch attendance with officer name and site (if available)
$stmt = $pdo->query("
  SELECT a.*, u.username, s.site_name
  FROM attendance a
  JOIN users u ON a.officer_id = u.id
  LEFT JOIN sites s ON u.site_id = s.id
  WHERE a.date = CURDATE()
  ORDER BY a.time_in DESC
");
$records = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>Today's Officer Attendance</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>

<body class="hold-transition sidebar-mini layout-fixed">

<div class="wrapper">
  <?php include '../includes/topbar.php'; ?>
  <?php include '../includes/sidebar_controller.php'; ?>

  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid d-flex justify-content-between align-items-center">
        <h4>🕒 Officers Logged In Today (<?= $today ?>)</h4>
        <span class="badge badge-primary p-2">Date: <?= $today ?></span>
      </div>
    
      <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
          <thead class="table-dark">
            <tr>
              <th>#</th>
              <th>Officer</th>
              <th>Site</th>
              <th>Time In</th>
              <th>Time Out</th>
              <th>Status</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($records as $i => $r): ?>
            <tr>
              <td><?= $i + 1 ?></td>
              <td><?= htmlspecialchars($r['username']) ?></td>
              <td><?= htmlspecialchars($r['site_name'] ?? 'Unassigned') ?></td>
              <td><?= $r['time_in'] ? date('h:i A', strtotime($r['time_in'])) : '-' ?></td>
              <td><?= $r['time_out'] ? date('h:i A', strtotime($r['time_out'])) : '<span class="text-danger">Not Signed Out</span>' ?></td>
              <td>
                <?php if ($r['time_in'] && $r['time_out']): ?>
                  <span class="badge bg-success">✔ Completed</span>
                <?php elseif ($r['time_in']): ?>
                  <span class="badge bg-warning text-dark">⏳ Active</span>
                <?php else: ?>
                  <span class="badge bg-secondary">-</span>
                <?php endif; ?>
              </td>
            </tr>
            <?php endforeach; ?>
            <?php if (empty($records)): ?>
              <tr><td colspan="6" class="text-center text-muted">No attendance recorded today.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
  </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>
