<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'controller') {
    header("Location: ../auth/login.php");
    exit;
}

$controller_id = $_SESSION['user_id'];

$stmt = $pdo->prepare("
    SELECT o.*, c.username AS controller_name
    FROM occurrences o
    JOIN users c ON o.controller_id = c.id
    WHERE o.controller_id = ?
    ORDER BY o.date DESC, o.time DESC
");
$stmt->execute([$controller_id]);
$occurrences = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>View Occurrences</title>
  <title>Record Occurrence</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <?php include '../includes/topbar_controller.php'; ?>
  <?php include '../includes/sidebar_controller.php'; ?>

<div class="content-wrapper">
      <div class="container mt-5">
        <h4 class="mb-4">📘 My Recorded Occurrences</h4>
        <a href="occurrence.php" class="btn btn-primary btn-sm mb-3"><i class="fas fa-plus-circle"></i> New Occurrence</a>
        <table id="userTable" class="table table-bordered table-striped text-sm">
          <thead class="table-dark">
            <tr>
              <th>#</th>
              <th>Date</th>
              <th>Time</th>
              <th>Subject</th>
              <th>Occurrences</th>
              <th>Controller</th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($occurrences as $i => $row): ?>
            <tr>
              <td><?= $i + 1 ?></td>
              <td><?= htmlspecialchars($row['date']) ?></td>
              <td><?= htmlspecialchars($row['time']) ?></td>
              <td><?= htmlspecialchars($row['title']) ?></td>
              <td><?= nl2br(htmlspecialchars($row['details'])) ?></td>
              <td><?= htmlspecialchars($row['controller_name']) ?></td>
            </tr>
          <?php endforeach; ?>
          <?php if (empty($occurrences)): ?>
            <tr><td colspan="5" class="text-center text-muted">No occurrences found.</td></tr>
          <?php endif; ?>
          </tbody>
        </table>
      </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>

<script>
  $(document).ready(function () {
    $('#userTable').DataTable();
      });

</script>
</body>
</html>
