<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

// Fetch data
$rosters = $pdo->query("
  SELECT cr.*, u.username, s.site_name 
  FROM controller_roster cr
  JOIN users u ON cr.controller_id = u.id
  JOIN sites s ON cr.site_id = s.id
  ORDER BY cr.shift_date DESC
")->fetchAll();

$controllers = $pdo->query("SELECT id, username FROM users WHERE role = 'controller'")->fetchAll();
$sites = $pdo->query("SELECT id, site_name FROM sites")->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
  <head>
  <meta name="description" content="Controller Dashboard - CFS System OS">
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Manage Controller Roster</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>

<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar_controller.php'; ?>

<div class="main-content" id="mainContent">
  <div class="container mt-4">
      <h4 class="mb-3">🧭 Manage Controller Roster</h4>

      <button class="btn btn-primary btn-sm mb-3" data-bs-toggle="modal" data-bs-target="#addModal">➕ Assign Shift</button>

      <table class="table table-bordered table-sm table-striped">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Controller</th>
            <th>Site</th>
            <th>Date</th>
            <th>Shift</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rosters as $i => $r): ?>
          <tr>
            <td><?= $i + 1 ?></td>
            <td><?= htmlspecialchars($r['username']) ?></td>
            <td><?= htmlspecialchars($r['site_name']) ?></td>
            <td><?= $r['shift_date'] ?></td>
            <td><?= ucfirst($r['shift_type']) ?> Shift</td>
            <td>
              <form action="controller_roster_action.php" method="post" class="d-inline" onsubmit="return confirm('Delete this shift?');">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" value="<?= $r['id'] ?>">
                <button class="btn btn-danger btn-sm">🗑️</button>
              </form>
            </td>
          </tr>
          <?php endforeach; ?>
          <?php if (empty($rosters)): ?>
          <tr><td colspan="6" class="text-center text-muted">No controller shifts assigned yet.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
  </div>

  <!-- Add Modal -->
  <div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog">
      <form action="controller_roster_action.php" method="post" class="modal-content">
        <input type="hidden" name="action" value="add">
        <div class="modal-header">
          <h5 class="modal-title">Assign New Controller Shift</h5>
          <button class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <select name="controller_id" class="form-select mb-2" required>
            <option value="">-- Select Controller --</option>
            <?php foreach ($controllers as $c): ?>
              <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['username']) ?></option>
            <?php endforeach; ?>
          </select>
          <select name="site_id" class="form-select mb-2" required>
            <option value="">-- Select Site --</option>
            <?php foreach ($sites as $s): ?>
              <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['site_name']) ?></option>
            <?php endforeach; ?>
          </select>
          <input type="date" name="shift_date" class="form-control mb-2" required>
          <select name="shift_type" class="form-select" required>
            <option value="day">Day</option>
            <option value="night">Night</option>
          </select>
        </div>
        <div class="modal-footer">
          <button class="btn btn-primary btn-sm">Add Shift</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
