<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$action = $_POST['action'] ?? '';
$id = $_POST['id'] ?? null;

if ($action === 'add') {
  $controller_id = $_POST['controller_id'];
  $site_id = $_POST['site_id'];
  $shift_date = $_POST['shift_date'];
  $shift_type = $_POST['shift_type'];

  $stmt = $pdo->prepare("INSERT INTO controller_roster (controller_id, site_id, shift_date, shift_type) VALUES (?, ?, ?, ?)");
  $stmt->execute([$controller_id, $site_id, $shift_date, $shift_type]);

} elseif ($action === 'delete' && $id) {
  $stmt = $pdo->prepare("DELETE FROM controller_roster WHERE id = ?");
  $stmt->execute([$id]);
}

header("Location: manage_controller_roster.php");
exit;
