<?php
session_start();
require_once '../includes/config.php';

$limit = 5;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;

$total = $pdo->query("SELECT COUNT(*) FROM incident_reports")->fetchColumn();
$pages = ceil($total / $limit);

$stmt = $pdo->prepare("SELECT * FROM incident_reports ORDER BY created_at DESC LIMIT :offset, :limit");
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->execute();
$incidents = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
  <title>Incident Reports (Admin)</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .preview-img { max-width: 100%; max-height: 150px; margin-bottom: 10px; }
    .preview-video { width: 100%; max-height: 240px; margin-bottom: 10px; }
  </style>
</head>
<body class="bg-light">
<div class="container mt-5">
  <h3 class="mb-4">📋 Incident Reports (Page <?= $page ?> of <?= $pages ?>)</h3>
  <?php foreach ($incidents as $incident): ?>
    <div class="card mb-4 shadow-sm">
      <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
        <div><strong><?= htmlspecialchars($incident['report_number']) ?></strong> — <?= htmlspecialchars($incident['subject']) ?></div>
        <div>
          <a href="edit_incident.php?id=<?= $incident['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
          <a href="delete_incident.php?id=<?= $incident['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this report?')">Delete</a>
        </div>
      </div>
      <div class="card-body">
        <!-- Back Button -->
          <div class="mb-3">
              <a href="dashboard.php" class="btn btn-secondary">⬅ Back to Dashboard</a>
          </div>
        <p><strong>Date:</strong> <?= $incident['incident_date'] ?> <strong>Time:</strong> <?= $incident['incident_date'] ?></p>
        <p><strong>Informant:</strong> <?= htmlspecialchars($incident['informant_name']) ?>
        <p><strong>Contact Number:</strong> (<?= htmlspecialchars($incident['contact_no']) ?>)</p>
        <p><strong>Recording Officer:</strong> <?= htmlspecialchars($incident['recording_officer']) ?></p>
        <p><strong>Status:</strong> <span class="badge bg-secondary"><?= $incident['status'] ?></span></p>

        <?php if (!empty($incident['photo'])): ?>
          <div class="mb-3">
            <strong>Photos:</strong><br>
            <div class="row">
              <?php foreach (json_decode($incident['photo']) as $img): ?>
                <div class="col-md-3">
                  <img src="../uploads/incidents/photos/<?= htmlspecialchars($img) ?>" class="preview-img img-thumbnail" alt="Photo">
                </div>
              <?php endforeach; ?>
            </div>
          </div>
        <?php endif; ?>

        <?php if (!empty($incident['video'])): ?>
          <div class="mb-3">
            <strong>Videos:</strong><br>
            <?php foreach (json_decode($incident['video']) as $vid): ?>
              <video controls class="preview-video">
                <source src="../uploads/incidents/videos/<?= htmlspecialchars($vid) ?>" type="video/mp4">
              </video>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
    </div>
  <?php endforeach; ?>

  <!-- Pagination -->
  <nav>
    <ul class="pagination justify-content-center">
      <?php for ($i = 1; $i <= $pages; $i++): ?>
        <li class="page-item<?= $i == $page ? ' active' : '' ?>">
          <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
        </li>
      <?php endfor; ?>
    </ul>
  </nav>
</div>
</body>
</html>
