<?php
session_start();
require_once '../includes/config.php';
// Add authentication check here if needed
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Officer Dashboard</title>
  <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <style>
    body {
      background-color: #f1f1f1;
    }
    .dashboard-container {
      max-width: 700px;
      margin: 40px auto;
      background: #fff;
      padding: 30px;
      border-radius: 10px;
    }
    #gpsStatus {
      font-size: 0.9rem;
      color: gray;
    }
  </style>
</head>
<body>

<div class="dashboard-container shadow">
  <h4 class="mb-4">👮 Officer Dashboard</h4>

  <div class="mb-3">
    <label for="location">Current Location</label>
    <input type="text" id="location" class="form-control" readonly>
    <div id="gpsStatus">Fetching location...</div>
  </div>

  <div class="d-grid gap-2">
    <button id="btnTimeIn" class="btn btn-success">📥 Mark Time In</button>
    <button id="btnTimeOut" class="btn btn-danger">📤 Mark Time Out</button>
  </div>

  <hr class="my-4">

  <div>
    <h6>📊 Attendance Status</h6>
    <p><strong>Date:</strong> <?= date('Y-m-d') ?></p>
    <p><strong>Time In:</strong> <span id="timeInDisplay">--:--</span></p>
    <p><strong>Time Out:</strong> <span id="timeOutDisplay">--:--</span></p>
  </div>
</div>

<script>
let currentGPS = "";

function updateLocation() {
  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(function(position) {
      currentGPS = position.coords.latitude + "," + position.coords.longitude;
      $('#location').val(currentGPS);
      $('#gpsStatus').text("📍 Location fetched successfully");
    }, function(error) {
      $('#gpsStatus').text("⚠️ Failed to get location: " + error.message);
    });
  } else {
    $('#gpsStatus').text("❌ Geolocation not supported by this browser.");
  }
}

updateLocation(); // Fetch on load

// Simulate attendance status (to be replaced with AJAX call)
$("#btnTimeIn").click(function() {
  const now = new Date().toLocaleTimeString();
  $("#timeInDisplay").text(now + " ✅");
  alert("Time In marked with location: " + currentGPS);
});

$("#btnTimeOut").click(function() {
  const now = new Date().toLocaleTimeString();
  $("#timeOutDisplay").text(now + " ✅");
  alert("Time Out marked with location: " + currentGPS);
});
</script>

<script>
// Function to send attendance data to the server
function sendAttendance(type) {
  if (!currentGPS) {
    alert("Location not yet fetched.");
    return;
  }

  $.post("mark_attendance.php", {
    type: type,
    gps: currentGPS
  }, function(response) {
    alert(response.message);
    if (response.status === "success") {
      const now = new Date().toLocaleTimeString();
      if (type === 'in') {
        $("#timeInDisplay").text(now + " ✅");
      } else {
        $("#timeOutDisplay").text(now + " ✅");
      }
    }
  }, 'json');
}

$("#btnTimeIn").click(() => sendAttendance('in'));
$("#btnTimeOut").click(() => sendAttendance('out'));

</script>

</body>
</html>
