<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

// Fetch payslips
$stmt = $pdo->query("
  SELECT p.*, u.username 
  FROM payslips p
  JOIN users u ON p.officer_id = u.id
  ORDER BY p.uploaded_at DESC
");
$payslips = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>View Payslips | CFS System OS</title>
  <meta charset="UTF-8">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content" id="mainContent">
    <div class="container mt-4">
      <h4>📄 Uploaded Payslips</h4>

      <div class="table-responsive mt-3">
        <table class="table table-bordered table-striped align-middle">
          <thead class="table-dark">
            <tr>
              <th>#</th>
              <th>Officer</th>
              <th>Month</th>
              <th>Uploaded On</th>
              <th>PDF</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($payslips as $i => $row): ?>
            <tr>
              <td><?= $i + 1 ?></td>
              <td><?= htmlspecialchars($row['username']) ?></td>
              <td><?= htmlspecialchars($row['month']) ?></td>
              <td><?= $row['uploaded_at'] ?></td>
              <td>
                <a href="../uploads/payslips/<?= htmlspecialchars($row['file_path']) ?>" target="_blank" class="btn btn-sm btn-primary">
                  View
                </a>
              </td>
            </tr>
            <?php endforeach; ?>
            <?php if (empty($payslips)): ?>
            <tr><td colspan="5" class="text-center text-muted">No payslips uploaded yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
</div>

</body>
</html>
