<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$year = isset($_GET['year']) ? intval($_GET['year']) : date('Y');

// Fetch leave balances
$stmt = $pdo->prepare("
  SELECT lb.*, u.username 
  FROM leave_balance lb
  JOIN users u ON lb.officer_id = u.id
  WHERE lb.year = ?
  ORDER BY u.username ASC
");
$stmt->execute([$year]);
$balances = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Officer Leave Balance | CFS System OS</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- AdminLTE + Plugins -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.5.0/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <?php include '../includes/topbar.php'; ?>
  <?php include '../includes/sidebar.php'; ?>

  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid d-flex justify-content-between align-items-center">
        <h4 class="mb-0">📋 Officer Leave Balance - <?= $year ?></h4>
        <form method="get" class="d-flex align-items-center">
          <input type="number" name="year" value="<?= $year ?>" class="form-control form-control-sm me-2" placeholder="Year">
          <button class="btn btn-sm btn-primary">Filter</button>
        </form>
      </div>
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="card card-primary">
          <div class="card-body table-responsive">
            <table id="siteTable" class="table table-bordered table-striped table-sm">
              <thead class="table-dark">
                <tr>
                  <th>#</th>
                  <th>Officer</th>
                  <th>Annual</th>
                  <th>Used</th>
                  <th>Medical</th>
                  <th>Used</th>
                  <th>Hospital</th>
                  <th>Used</th>
                  <th>Unpaid</th>
                  <th>Used</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($balances as $i => $b): ?>
                <tr>
                  <td><?= $i + 1 ?></td>
                  <td><?= htmlspecialchars($b['username']) ?></td>
                  <td><?= $b['annual_leave'] ?></td>
                  <td><?= $b['used_annual'] ?></td>
                  <td><?= $b['medical_leave'] ?></td>
                  <td><?= $b['used_medical'] ?></td>
                  <td><?= $b['hospital_leave'] ?></td>
                  <td><?= $b['used_hospital'] ?></td>
                  <td><?= $b['unpaid_leave'] ?></td>
                  <td><?= $b['used_unpaid'] ?></td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($balances)): ?>
                <tr><td colspan="10" class="text-center text-muted">No records found for <?= $year ?>.</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </section>
  </div>

</div>

<!-- JS Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>

<script>
  $(document).ready(function () {
    $('#siteTable').DataTable({
      order: [[1, 'asc']],
      pageLength: 25
    });
  });
</script>
</body>
</html>
