<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$stmt = $pdo->query("SELECT * FROM sites ORDER BY created_at DESC");
$sites = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Manage Sites | CFS System OS</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.5.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
  <style>
    body { font-size: 0.9rem; }
    .content-wrapper { background-color: #f4f6f9; }
  </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid d-flex justify-content-between align-items-center">
      <h4 class="mb-0">🏢 Manage Sites</h4>
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSiteModal">
        <i class="fas fa-plus-circle"></i> Add New Site
      </button>
    </div>
  </div>

  <div class="content">
    <div class="container-fluid">
      <div class="card">
        <div class="card-header bg-primary text-white">
          <h5 class="card-title">All Sites</h5>
        </div>
        <div class="card-body table-responsive">

         <table id="siteTable" class="table table-bordered table-striped text-sm">
            <thead class="table-dark">
              <tr>
                <th>#</th>
                <th>Site Name</th>
                <th>Location</th>
                <th>Status</th>
                <th>Contract Start</th>
                <th>Contract End</th>
                <th>Duration</th>
                <th>Officers</th>
                <th>Created</th>
                <th>View</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php $i = 1; foreach ($sites as $site): ?>
                <?php
                $stmt2 = $pdo->prepare("SELECT COUNT(*) FROM users WHERE role = 'officer' AND site_id = ?");
                $stmt2->execute([$site['id']]);
                $officerCount = $stmt2->fetchColumn();
                ?>
                <tr>
                  <td><?= $i++ ?></td>
                  <td><?= htmlspecialchars($site['site_name']) ?></td>
                  <td><?= htmlspecialchars($site['location']) ?></td>
                  <td><span class="badge <?= $site['status'] === 'active' ? 'bg-success' : 'bg-secondary' ?>"><?= ucfirst($site['status']) ?></span></td>
                  <td><?= date('d M Y', strtotime($site['contract_start'])) ?></td>
                  <td><?= date('d M Y', strtotime($site['contract_end'])) ?></td>
                  <td><?= htmlspecialchars($site['contract_duration']) ?></td>
                  <td><?= $officerCount ?></td>
                  <td><?= date('d M Y', strtotime($site['created_at'])) ?></td>
                  <td>
                    <button class="btn btn-sm btn-info viewOfficersBtn"
                      data-site="<?= htmlspecialchars($site['site_name']) ?>"
                      data-id="<?= $site['id'] ?>">
                      <i class="fas fa-users"></i>
                    </button>
                  </td>
                  <td>
                    <button class="btn btn-sm btn-warning editBtn"
                      data-id="<?= $site['id'] ?>"
                      data-name="<?= htmlspecialchars($site['site_name']) ?>"
                      data-location="<?= htmlspecialchars($site['location']) ?>"
                      data-status="<?= $site['status'] ?>"
                      data-start="<?= $site['contract_start'] ?>"
                      data-end="<?= $site['contract_end'] ?>">
                      <i class="fas fa-edit"></i>
                    </button>
                    <a href="delete_site.php?id=<?= $site['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this site?')">
                      <i class="fas fa-trash"></i>
                    </a>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Add Site Modal -->
<div class="modal fade" id="addSiteModal" tabindex="-1">
  <div class="modal-dialog">
    <form action="add_site.php" method="POST" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Add New Site</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label>Site Name</label>
          <input type="text" name="site_name" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Location</label>
          <input type="text" name="location" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Status</label>
          <select name="status" class="form-control">
            <option value="active">Active</option>
            <option value="inactive">Inactive</option>
          </select>
        </div>
        <div class="mb-3">
          <label>Contract Start</label>
          <input type="date" name="contract_start" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Contract End</label>
          <input type="date" name="contract_end" class="form-control" required>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-success" type="submit">Add</button>
        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>

<!-- Edit Site Modal -->
<div class="modal fade" id="editSiteModal" tabindex="-1">
  <div class="modal-dialog">
    <form action="update_site.php" method="POST" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Edit Site</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="id" id="edit-id">
        <div class="mb-3">
          <label>Site Name</label>
          <input type="text" name="site_name" id="edit-name" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Location</label>
          <input type="text" name="location" id="edit-location" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Status</label>
          <select name="status" id="edit-status" class="form-control">
            <option value="active">Active</option>
            <option value="inactive">Inactive</option>
          </select>
        </div>
        <div class="mb-3">
          <label>Contract Start</label>
          <input type="date" name="contract_start" id="edit-start" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Contract End</label>
          <input type="date" name="contract_end" id="edit-end" class="form-control" required>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" type="submit">Update</button>
        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>

<!-- View Officers Modal -->
<div class="modal fade" id="officerModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Assigned Officers for <span id="modalSiteName"></span></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <ul id="officerList" class="list-group"></ul>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

<script>
  $('#siteTable').DataTable({
    dom: 'Bfrtip',
    buttons: ['csv', 'print'],
    order: [[2, 'desc']],
    pageLength: 10
  });
</script>

<script>
$(document).ready(function () {
  $('.editBtn').click(function () {
    $('#edit-id').val($(this).data('id'));
    $('#edit-name').val($(this).data('name'));
    $('#edit-location').val($(this).data('location'));
    $('#edit-status').val($(this).data('status'));
    $('#edit-start').val($(this).data('start'));
    $('#edit-end').val($(this).data('end'));
    new bootstrap.Modal(document.getElementById('editSiteModal')).show();
  });

  $('.viewOfficersBtn').click(function () {
    const siteId = $(this).data('id');
    const siteName = $(this).data('site');
    $('#modalSiteName').text(siteName);
    $.post('get_site_officers.php', { site_id: siteId }, function (data) {
      $('#officerList').html(data);
      new bootstrap.Modal(document.getElementById('officerModal')).show();
    });
  });
});
</script>
</body>
</html>
