<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

// Incident report query logic already inside this file below
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Incident Reports | Admin Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <?php include '../includes/topbar.php'; ?>
  <?php include '../includes/sidebar.php'; ?>

  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <h4 class="mb-0">📋 Incident Reports</h4>
      </div>
    </section>

    
<section class="content">
  <div class="container-fluid">
    <div class="mb-3 d-flex justify-content-between align-items-center">
      <div>
        <input type="text" id="searchBox" class="form-control form-control-sm" placeholder="🔍 Search incidents..." style="width: 300px;">
      </div>
      <div>
        <button onclick="window.print()" class="btn btn-sm btn-outline-primary"><i class="fas fa-print"></i> Print</button>
        <button onclick="exportTableToExcel('userTable')" class="btn btn-sm btn-outline-success"><i class="fas fa-file-excel"></i> Export Excel</button>
      </div>
    </div>

    <table id="userTable" class="table table-bordered table-striped text-sm">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Date</th>
          <th>Time</th>
          <th>Subject</th>
          <th>Details</th>
          <th>Status</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($data as $i => $r): ?>
          <?php
            $statusText = $r['status'];
            switch ($statusText) {
              case 'resolved':
                $status = "<span class='badge bg-success'>Resolved</span>";
                break;
              case 'rejected':
                $status = "<span class='badge bg-danger'>Rejected</span>";
                break;
              default:
                $status = "<span class='badge bg-secondary'>Pending</span>";
            }
          ?>
          <tr>
            <td><?= $i + 1 ?></td>
            <td><?= htmlspecialchars($r['date']) ?></td>
            <td><?= htmlspecialchars($r['time']) ?></td>
            <td><?= htmlspecialchars($r['title']) ?></td>
            <td><?= nl2br(htmlspecialchars($r['details'])) ?></td>
            <td><?= $status ?></td>
            <td>
              <a href="incident_view.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-info"><i class="fas fa-eye"></i></a>
              <a href="incident_edit.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a>
              <a href="incident_delete.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this incident?');"><i class="fas fa-trash-alt"></i></a>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (empty($data)): ?>
          <tr><td colspan="7" class="text-center text-muted">No incident reports found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>

  </div>

  <?php include '../includes/footer.php'; ?>
</div>

<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script>
  $(document).ready(function () {
    $('#userTable').DataTable();
  });
</script>

</body>
</html>

<script>
  function exportTableToExcel(tableID, filename = '') {
    let downloadLink;
    const dataType = 'application/vnd.ms-excel';
    const tableSelect = document.getElementById(tableID);
    const tableHTML = tableSelect.outerHTML.replace(/ /g, '%20');
    filename = filename ? filename + '.xls' : 'incident_reports.xls';
    downloadLink = document.createElement("a");
    document.body.appendChild(downloadLink);
    if (navigator.msSaveOrOpenBlob) {
      const blob = new Blob(['﻿', tableHTML], { type: dataType });
      navigator.msSaveOrOpenBlob(blob, filename);
    } else {
      downloadLink.href = 'data:' + dataType + ', ' + tableHTML;
      downloadLink.download = filename;
      downloadLink.click();
    }
  }
</script>
