<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$year = isset($_GET['year']) ? intval($_GET['year']) : date('Y');

// Fetch all officer leave balances
$stmt = $pdo->prepare("
  SELECT lb.*, u.username FROM leave_balance lb
  JOIN users u ON lb.officer_id = u.id
  WHERE lb.year = ?
  ORDER BY u.username ASC
");
$stmt->execute([$year]);
$balances = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>View Officer Leave Balance</title>
  <meta charset="UTF-8" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content" id="mainContent">

<div class="container mt-4">
  <h4>📋 Officer Leave Balance - <?= $year ?></h4>

  <form method="get" class="mb-3 row g-2">
    <div class="col-md-3">
      <input type="number" name="year" value="<?= $year ?>" class="form-control" placeholder="Filter by Year">
    </div>
    <div class="col-auto">
      <button class="btn btn-primary">Filter</button>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-bordered table-striped align-middle small">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Officer</th>
          <th>Annual</th>
          <th>Used</th>
          <th>Medical</th>
          <th>Used</th>
          <th>Hospital</th>
          <th>Used</th>
          <th>Unpaid</th>
          <th>Used</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($balances as $i => $b): ?>
        <tr>
          <td><?= $i + 1 ?></td>
          <td><?= htmlspecialchars($b['username']) ?></td>
          <td><?= $b['annual_leave'] ?></td>
          <td><?= $b['used_annual'] ?></td>
          <td><?= $b['medical_leave'] ?></td>
          <td><?= $b['used_medical'] ?></td>
          <td><?= $b['hospital_leave'] ?></td>
          <td><?= $b['used_hospital'] ?></td>
          <td><?= $b['unpaid_leave'] ?></td>
          <td><?= $b['used_unpaid'] ?></td>
        </tr>
        <?php endforeach; ?>
        <?php if (empty($balances)): ?>
        <tr><td colspan="10" class="text-center text-muted">No records found for <?= $year ?>.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

</div>
</body>
</html>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>