<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$success = $error = '';

// Upload handler
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $officer_id = $_POST['officer_id'];
  $position = $_POST['position'];
  $start = $_POST['start_date'];
  $end = $_POST['end_date'];

  $uploadDir = "../uploads/kets/";
  if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
  }

  if ($_FILES['contract']['error'] === 0) {
    $fileType = mime_content_type($_FILES['contract']['tmp_name']);
    if ($fileType === 'application/pdf') {
      $filename = time() . "_" . basename($_FILES['contract']['name']);
      $target = $uploadDir . $filename;
      if (move_uploaded_file($_FILES['contract']['tmp_name'], $target)) {
        $stmt = $pdo->prepare("INSERT INTO employment_terms (officer_id, position, start_date, end_date, contract_file) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$officer_id, $position, $start, $end, $filename]);
        $success = "Employment term uploaded successfully.";
      } else {
        $error = "File upload failed.";
      }
    } else {
      $error = "Only PDF files allowed.";
    }
  } else {
    $error = "No file uploaded.";
  }
}

// Fetch officers
$officers = $pdo->query("SELECT id, username FROM users WHERE role = 'officer' ORDER BY username ASC")->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>Upload Employment Terms (KET)</title>
  <meta charset="UTF-8" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content" id="mainContent">
        <div class="container mt-4" style="max-width: 700px;">
        <h4>📑 Upload Employment Terms</h4>

        <?php if ($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>
        <?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>

        <form method="post" enctype="multipart/form-data">
            <div class="mb-3">
            <label class="form-label">Select Officer</label>
            <select name="officer_id" class="form-select" required>
                <option value="">-- Select Officer --</option>
                <?php foreach ($officers as $o): ?>
                <option value="<?= $o['id'] ?>"><?= htmlspecialchars($o['username']) ?></option>
                <?php endforeach; ?>
            </select>
            </div>

            <div class="mb-3">
            <label class="form-label">Position</label>
            <input name="position" class="form-control" required>
            </div>

            <div class="mb-3 row">
            <div class="col">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" class="form-control" required>
            </div>
            <div class="col">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" class="form-control" required>
            </div>
            </div>

            <div class="mb-3">
            <label class="form-label">Contract File (PDF)</label>
            <input type="file" name="contract" accept="application/pdf" class="form-control" required>
            </div>

            <div class="d-flex gap-2">
            <button class="btn btn-primary">Upload</button>
            <a href="view_employment_terms.php" class="btn btn-outline-secondary">View All</a>
            </div>
        </form>
        </div>
</div>
</body>
</html>
