<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

// KPIs
$totalOfficers = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'officer'")->fetchColumn();
$totalSites = $pdo->query("SELECT COUNT(*) FROM sites")->fetchColumn();
$totalIncidents = $pdo->query("SELECT COUNT(*) FROM incident_reports")->fetchColumn();
$totalToday = $pdo->query("SELECT COUNT(*) FROM attendance WHERE date = CURDATE()")->fetchColumn();

// Chart data
$trend = $pdo->query("SELECT DATE(date) as day, COUNT(*) as count FROM attendance GROUP BY day ORDER BY day DESC LIMIT 7")->fetchAll();
$trendLabels = json_encode(array_column($trend, 'day'));
$trendCounts = json_encode(array_column($trend, 'count'));
?>

<!DOCTYPE html>
<html>
<head>
  <title>Admin Dashboard | CFS System OS</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
 
  <style>
  body {
    background-color: #f2f4f8;
    font-size: 14px;
  }

  h4 {
    font-weight: 600;
    color: #004080;
  }

  .card-box {
    background: #fff;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 0 10px rgba(0,0,0,0.04);
    margin-bottom: 20px;
  }

  .section-title {
    font-size: 15px;
    font-weight: 600;
    margin-bottom: 12px;
    color: #2c3e50;
  }

  .btn {
    font-size: 13px;
  }

  table.table-sm th, table.table-sm td {
    vertical-align: middle;
  }

  .table th {
    background-color: #e9ecef;
  }

  .badge {
    font-size: 11px;
  }

  .alert {
    padding: 8px 12px;
    font-size: 13px;
  }
</style>

</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content" id="mainContent">

    <div class="container my-4">
    <h4 class="text-black">Welcome, <?= htmlspecialchars($_SESSION['username'] ?? 'Admin') ?></h4>
      <div class="row text-center g-4">
        <div class="col-md-3">
          <div class="card card-kpi p-4">
            <h6>👮 Total Officers</h6>
            <h3><?= $totalOfficers ?></h3>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card card-kpi p-4">
            <h6>🏢 Sites</h6>
            <h3><?= $totalSites ?></h3>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card card-kpi p-4">
            <h6>🚨 Incidents</h6>
            <h3><?= $totalIncidents ?></h3>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card card-kpi p-4">
            <h6>🕒 Attendance Today</h6>
            <h3><?= $totalToday ?></h3>
          </div>
        </div>
      </div>

      <div class="row mt-5">
        <div class="col-md-12">
          <h5 class="section-title">📊 Attendance Trend (Last 7 Days)</h5>
          <div class="card p-3 shadow-sm bg-white rounded">
            <canvas id="trendChart" height="90"></canvas>
          </div>
        </div>
      </div>
    </div>
</div>

<script>
  const ctx = document.getElementById('trendChart').getContext('2d');
  new Chart(ctx, {
    type: 'bar',
    data: {
      labels: <?= $trendLabels ?>,
      datasets: [{
        label: 'Check-ins',
        data: <?= $trendCounts ?>,
        backgroundColor: '#004080',
        borderRadius: 8
      }]
    },
    options: {
      responsive: true,
      scales: {
        y: {
          beginAtZero: true,
          ticks: { stepSize: 1 }
        }
      }
    }
  });
</script>



</body>
</html>
