<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$id = $_POST['id'];
$action = $_POST['action']; // approve or reject

$stmt = $pdo->prepare("SELECT * FROM leave_requests WHERE id = ?");
$stmt->execute([$id]);
$leave = $stmt->fetch();

if (!$leave) {
  exit("Leave not found.");
}

if ($action === 'approve') {
  // Calculate duration
  $start = new DateTime($leave['start_date']);
  $end = new DateTime($leave['end_date']);
  $days = $start->diff($end)->days + 1;

  $field = [
    'annual' => 'used_annual',
    'medical' => 'used_medical',
    'hospital' => 'used_hospital',
    'unpaid' => 'used_unpaid'
  ][$leave['leave_type']];

  // Update used leave after approval
  $pdo->prepare("UPDATE leave_balance SET $field = $field + ? WHERE officer_id = ? AND year = ?")
      ->execute([$days, $leave['officer_id'], date('Y')]);

  $pdo->prepare("UPDATE leave_requests SET status = 'approved' WHERE id = ?")->execute([$id]);

} elseif ($action === 'reject') {
  $pdo->prepare("UPDATE leave_requests SET status = 'rejected' WHERE id = ?")->execute([$id]);
}

header("Location: view_leave_requests.php");
exit;
