<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HRMS - Corporate Force Security</title>
    <link rel="stylesheet" href="assets/css/styles.css">
    <style>
        /* Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            overflow: hidden;
            position: relative;
        }

        /* Video Background */
        #bg-video {
            position: fixed;
            top: 50%;
            left: 50%;
            min-width: 100%;
            min-height: 100%;
            width: auto;
            height: auto;
            transform: translate(-50%, -50%);
            z-index: -1;
        }

        /* Overlay for Better Readability */
        .video-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.4);
            z-index: 1;
        }

        /* Loading Screen */
        .loading-screen {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: #1a1a1a;
            display: flex;
            justify-content: center;
            align-items: center;
            transition: opacity 0.5s ease;
            z-index: 9999;
        }

        .loader {
            border: 8px solid #f3f3f3;
            border-top: 8px solid #3498db;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Splash Content */
        .splash-container {
            position: relative;
            z-index: 2;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            padding: 20px;
        }

        .content {
            max-width: 600px;
            opacity: 0;
            animation: fadeIn 1.5s ease 0.5s forwards;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Logo Styling */
        .logo {
            width: 150px;
            height: auto;
            margin-bottom: 30px;
            transition: transform 0.3s ease;
        }

        .logo:hover {
            transform: scale(1.05);
        }

        /* Typography */
        h1 {
            color: white;
            font-size: 3.2em;
            margin-bottom: 20px;
            text-shadow: 0 2px 5px rgba(0, 0, 0, 0.3);
        }

        #dynamic-tagline {
            color: #3498db;
            font-size: 1.5em;
            margin-bottom: 40px;
            position: relative;
            transition: color 0.3s ease;
        }

        /* Login Button */
        .btn {
            background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
            color: white;
            padding: 15px 40px;
            border: none;
            border-radius: 50px;
            font-size: 1.1em;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(52, 152, 219, 0.4);
            text-decoration: none;
            display: inline-block;
        }

        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(52, 152, 219, 0.6);
        }

        .btn:active {
            transform: translateY(-1px);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            h1 {
                font-size: 2.5em;
            }
            
            #dynamic-tagline {
                font-size: 1.2em;
            }
            
            .logo {
                width: 120px;
            }
            
            .btn {
                padding: 12px 30px;
                font-size: 1em;
            }
        }

        /* Error Message Styling */
        .error-message {
            position: fixed;
            top: 20px;
            right: 20px;
            background: #e74c3c;
            color: white;
            padding: 15px 25px;
            border-radius: 8px;
            display: none;
            animation: slideIn 0.5s ease;
        }

        @keyframes slideIn {
            from { transform: translateX(100%); }
            to { transform: translateX(0); }
        }
    </style>
</head>
<body>
    <!-- Background Video -->
    <video autoplay muted loop id="bg-video">
        <source src="assets/videos/background.mp4" type="video/mp4">
        Your browser does not support HTML5 video.
    </video>
    <div class="video-overlay"></div>

    <!-- Loading Screen -->
    <div class="loading-screen">
        <div class="loader"></div>
    </div>

    <!-- Error Message Container -->
    <div class="error-message" id="errorMessage"></div>

    <div class="splash-container">
        <div class="content">
            <!-- Company Logo -->
            <img src="assets/images/app_logo.png" alt="Corporate Force Security Logo" class="logo">
            
            <h1>Welcome to OPS Security System</h1>

            <!-- Dynamic Quote / Tagline -->
            <p id="dynamic-tagline">"We Make The Difference"</p>

            <a href="auth/login.php" class="btn">Login</a>
        </div>
    </div>

    <script>
        // Hide loading screen after page load
        window.addEventListener("load", function() {
            const loadingScreen = document.querySelector(".loading-screen");
            loadingScreen.style.opacity = "0";
            setTimeout(() => loadingScreen.style.display = "none", 500);
        });

        // Dynamic Quote Animation
        const quotes = [
            '"We Make The Difference"',
            '"Empowering Security Through Innovation"',
            '"Your Security, Our Priority"',
            '"Building Trust, Ensuring Safety"',
            '"Reliable Security Solutions for Every Need"'
        ];
        
        let index = 0;
        const tagline = document.getElementById("dynamic-tagline");

        function changeQuote() {
            index = (index + 1) % quotes.length;
            tagline.style.opacity = 0;
            
            setTimeout(() => {
                tagline.textContent = quotes[index];
                tagline.style.opacity = 1;
            }, 300);
        }

        setInterval(changeQuote, 4000);

        // Error message handling (if needed)
        function showError(message) {
            const errorDiv = document.getElementById("errorMessage");
            errorDiv.textContent = message;
            errorDiv.style.display = "block";
            
            setTimeout(() => {
                errorDiv.style.display = "none";
            }, 5000);
        }
    </script>
</body>
</html>