<?php
session_start();
require_once '../includes/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $recipient_role = $_POST['recipient_role'];
  $message = $_POST['message'];

  $stmt = $pdo->prepare("INSERT INTO notifications (recipient_id, recipient_role, message) VALUES (?, ?, ?)");
  if ($recipient_role === 'officer') {
    $officers = $pdo->query("SELECT id FROM officers")->fetchAll();
    foreach ($officers as $o) {
      $stmt->execute([$o['id'], 'officer', $message]);
    }
  } else {
    $stmt->execute([1, 'admin', $message]); // Replace 1 with actual admin ID
  }

  $success = "Message sent!";
}
?>

<form method="post" class="p-4">
  <h5>📢 Send Notification</h5>
  <?php if (!empty($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
  <select name="recipient_role" class="form-control mb-2" required>
    <option value="officer">All Officers</option>
    <option value="admin">Admin</option>
  </select>
  <textarea name="message" class="form-control mb-2" rows="3" required></textarea>
  <button class="btn btn-primary">Send</button>
</form>
