<?php
session_start();
require_once '../includes/config.php';

$stmt = $pdo->query("SELECT * FROM incident_reports ORDER BY created_at DESC");
$incidents = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head><title>Incident Reports</title></head>
<body>
<h3>Incident Reports</h3>
<?php foreach ($incidents as $i): ?>
  <div style="border:1px solid #ccc; padding:10px; margin-bottom:10px;">
    <strong><?= htmlspecialchars($i['title']) ?></strong><br>
    <small><?= $i['created_at'] ?> | Severity: <?= $i['severity'] ?> | Status: <?= $i['status'] ?></small><br>
    <?= nl2br(htmlspecialchars($i['description'])) ?><br>
    <?php if ($i['evidence_file']): ?>
      <img src="../uploads/incidents/<?= $i['evidence_file'] ?>" width="200"><br>
    <?php endif; ?>
    <a href="review_incident.php?id=<?= $i['id'] ?>">Review</a>
  </div>
<?php endforeach; ?>
</body>
</html>
