<?php
declare(strict_types=1);
require_once __DIR__ . '/../includes/auth.php';
require_role(['admin','hr']);

$stmt = db()->query("
    SELECT u.id, u.full_name, u.email, u.status, u.photo_path,
           GROUP_CONCAT(r.role_name SEPARATOR ', ') AS roles
    FROM users u
    LEFT JOIN user_roles ur ON ur.user_id = u.id
    LEFT JOIN roles r ON r.id = ur.role_id
    GROUP BY u.id
    ORDER BY u.id DESC
");
$rows = $stmt->fetchAll();

include __DIR__ . '/../includes/header.php';
?>

<style>
.card-ultra {
    background: rgba(0,0,0,0.45);
    border: 1px solid rgba(0,229,255,0.15);
    border-radius: 18px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.6);
}

.table-ultra thead th {
    background: rgba(0,229,255,0.05);
    color: #00e5ff;
    border-bottom: 1px solid rgba(0,229,255,0.2);
    text-transform: uppercase;
    font-size: 12px;
    letter-spacing: 1px;
}

.table-ultra tbody tr {
    transition: 0.2s ease;
}

.table-ultra tbody tr:hover {
    background: rgba(0,229,255,0.05);
}

.profile-img {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    object-fit: cover;
    border: 2px solid rgba(0,229,255,0.5);
    box-shadow: 0 0 12px rgba(0,229,255,0.6);
}

.status-dot {
    width: 10px;
    height: 10px;
    border-radius: 50%;
    display: inline-block;
    margin-right: 6px;
}

.status-active { background:#2aff7a; box-shadow:0 0 8px #2aff7a; }
.status-inactive { background:#ff5252; box-shadow:0 0 8px #ff5252; }
.status-suspended { background:#ffc107; box-shadow:0 0 8px #ffc107; }

.role-badge {
    background: rgba(0,229,255,0.1);
    border: 1px solid rgba(0,229,255,0.3);
    color: #00e5ff;
    padding: 4px 8px;
    border-radius: 20px;
    font-size: 11px;
    margin-right: 4px;
}
</style>

<div class="card card-ultra">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h3 class="card-title text-info">
            <i class="fas fa-users"></i> User Command Console
        </h3>
        <a href="add.php" class="btn btn-outline-info btn-sm">
            <i class="fas fa-user-plus"></i> Add Operator
        </a>
    </div>

    <div class="card-body table-responsive p-0">
        <table class="table table-ultra table-hover mb-0">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Profile</th>
                    <th>Operator</th>
                    <th>Role</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($rows as $r): 
                $photo = $r['photo_path'] ?: '../assets/img/default-avatar.png';
            ?>
                <tr>
                    <td class="align-middle"><?= (int)$r['id'] ?></td>

                    <td class="align-middle">
                        <img src="../<?= htmlspecialchars($photo) ?>" class="profile-img">
                    </td>

                    <td class="align-middle">
                        <strong><?= htmlspecialchars($r['full_name']) ?></strong><br>
                        <small class="text-muted"><?= htmlspecialchars($r['email']) ?></small>
                    </td>

                    <td class="align-middle">
                        <?php
                        $roles = explode(',', $r['roles'] ?? '');
                        foreach ($roles as $role):
                        ?>
                            <span class="role-badge"><?= htmlspecialchars(trim($role)) ?></span>
                        <?php endforeach; ?>
                    </td>

                    <td class="align-middle">
                        <?php
                        $statusClass = 'status-active';
                        if ($r['status'] === 'inactive') $statusClass = 'status-inactive';
                        if ($r['status'] === 'suspended') $statusClass = 'status-suspended';
                        ?>
                        <span class="status-dot <?= $statusClass ?>"></span>
                        <?= ucfirst($r['status']) ?>
                    </td>

                    <td class="align-middle">
                        <a href="edit.php?id=<?= (int)$r['id'] ?>" 
                           class="btn btn-sm btn-outline-warning">
                           <i class="fas fa-pen"></i>
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>