<?php
declare(strict_types=1);
require_once __DIR__ . '/../includes/auth.php';
require_role(['admin','hr']);

$roles = db()->query("SELECT id, role_name FROM roles ORDER BY id")->fetchAll();
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    csrf_validate($_POST['_csrf'] ?? null);

    $name = trim((string)$_POST['full_name']);
    $email = trim((string)$_POST['email']);
    $pass = (string)$_POST['password'];
    $roleId = (int)($_POST['role_id'] ?? 0);

    if ($name === '' || $email === '' || strlen($pass) < 8 || $roleId <= 0) {
        $error = 'All fields required. Password minimum 8 characters.';
    } else {

        // ===== PHOTO UPLOAD =====
        $photoPath = null;

        if (!empty($_FILES['photo']['tmp_name'])) {

            $allowed = ['jpg','jpeg','png'];
            $ext = strtolower(pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION));

            if (!in_array($ext, $allowed, true)) {
                $error = 'Invalid photo format (jpg, jpeg, png only).';
            } else {

                $uploadDir = __DIR__ . '/../assets/uploads/profile/';
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0755, true);
                }

                $filename = 'user_' . time() . '_' . bin2hex(random_bytes(5)) . '.' . $ext;
                $destination = $uploadDir . $filename;

                if (move_uploaded_file($_FILES['photo']['tmp_name'], $destination)) {
                    $photoPath = 'assets/uploads/profile/' . $filename;
                } else {
                    $error = 'Photo upload failed.';
                }
            }
        }

        if ($error === '') {
            $hash = password_hash($pass, PASSWORD_DEFAULT);

            $stmt = db()->prepare("
                INSERT INTO users(full_name,email,password_hash,status,photo_path)
                VALUES(?,?,?,'active',?)
            ");
            $stmt->execute([$name,$email,$hash,$photoPath]);

            $uid = (int)db()->lastInsertId();
            db()->prepare("INSERT INTO user_roles(user_id, role_id) VALUES(?,?)")
               ->execute([$uid,$roleId]);

            header('Location: index.php');
            exit;
        }
    }
}

include __DIR__ . '/../includes/header.php';
?>

<style>
.card-ultra {
    background: rgba(0,0,0,0.45);
    border: 1px solid rgba(0,229,255,0.15);
    border-radius: 18px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.6);
}

.form-control, .custom-select {
    background: rgba(255,255,255,0.05);
    border: 1px solid rgba(0,229,255,0.2);
    color: #fff;
}

.form-control:focus {
    border-color: #00e5ff;
    box-shadow: 0 0 10px rgba(0,229,255,0.5);
}

.profile-preview {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid rgba(0,229,255,0.5);
    box-shadow: 0 0 20px rgba(0,229,255,0.6);
    margin-bottom: 15px;
}

.btn-ultra {
    background: linear-gradient(135deg,#00e5ff,#2aff7a);
    border: none;
    color: #000;
    font-weight: 600;
}
.role-select {
    background-color: #0f1b2e;
    border: 1px solid rgba(0,229,255,0.3);
    color: #ffffff;
}

.role-select option {
    background-color: #0f1b2e;
    color: #ffffff;
}
</style>

<div class="card card-ultra">
    <div class="card-header">
        <h3 class="card-title text-info">
            <i class="fas fa-user-plus"></i> Register Operator
        </h3>
    </div>

    <div class="card-body">

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="post" enctype="multipart/form-data">
            <input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()) ?>">

            <div class="row">
                <div class="col-md-4 text-center">
                    <img src="../assets/img/default-avatar.png" 
                         id="photoPreview" 
                         class="profile-preview">

                    <div class="form-group">
                        <label class="text-info">Operator Photo</label>
                        <input type="file" 
                               name="photo" 
                               class="form-control-file text-light"
                               accept="image/png,image/jpeg"
                               onchange="previewImage(event)">
                    </div>
                </div>

                <div class="col-md-8">

                    <div class="form-group">
                        <label>Full Name</label>
                        <input name="full_name" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label>Email</label>
                        <input name="email" type="email" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label>Password</label>
                        <input name="password" type="password" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="text-info">Role</label>
                        <select name="role_id" class="form-control role-select" required>
                            <option value="">-- Select Role --</option>
                            <?php foreach($roles as $r): ?>
                                <option value="<?= (int)$r['id'] ?>">
                                    <?= htmlspecialchars($r['role_name']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php var_dump($roles); ?>

                    <button class="btn btn-ultra">
                        <i class="fas fa-save"></i> Deploy Operator
                    </button>

                    <a href="index.php" class="btn btn-outline-light ml-2">
                        Cancel
                    </a>

                </div>
            </div>
        </form>
    </div>
</div>

<script>
function previewImage(event) {
    const reader = new FileReader();
    reader.onload = function(){
        const output = document.getElementById('photoPreview');
        output.src = reader.result;
    };
    reader.readAsDataURL(event.target.files[0]);
}
</script>

<?php include __DIR__ . '/../includes/footer.php'; ?>