<?php
require_once __DIR__ . '/auth.php';

$me    = current_user();
$roles = $me['roles'] ?? [];

function active(string $path): string {
    $uri = $_SERVER['REQUEST_URI'] ?? '';
    return (strpos($uri, $path) !== false) ? 'active' : '';
}
function openMenu(string $path): string {
    $uri = $_SERVER['REQUEST_URI'] ?? '';
    return (strpos($uri, $path) !== false) ? 'menu-open' : '';
}
function hasRole(array $roles, string $roleKey): bool {
    return in_array($roleKey, $roles, true);
}
function anyRole(array $roles, array $roleKeys): bool {
    foreach ($roleKeys as $rk) if (in_array($rk, $roles, true)) return true;
    return false;
}

$displayRole = 'User';
if (in_array('admin', $roles, true)) $displayRole = 'Administrator';
elseif (in_array('hr', $roles, true)) $displayRole = 'HR';
elseif (in_array('manager', $roles, true)) $displayRole = 'Manager';
elseif (in_array('supervisor', $roles, true)) $displayRole = 'Supervisor';
elseif (in_array('controller', $roles, true)) $displayRole = 'Controller';
elseif (in_array('guard', $roles, true)) $displayRole = 'Guard';

$homeUrl = BASE_URL . '/guard/dashboard.php';
if (in_array('admin', $roles, true)) $homeUrl = BASE_URL . '/admin/dashboard.php';
elseif (in_array('hr', $roles, true)) $homeUrl = BASE_URL . '/hr/dashboard.php';
elseif (in_array('manager', $roles, true)) $homeUrl = BASE_URL . '/manager/dashboard.php';
elseif (in_array('supervisor', $roles, true)) $homeUrl = BASE_URL . '/supervisor/dashboard.php';
elseif (in_array('controller', $roles, true)) $homeUrl = BASE_URL . '/controller/dashboard.php';
?>
<style>
  :root{
    --hud:#00e5ff;
    --hud2:#2aff7a;
    --gold:#C9A24D;
    --line: rgba(255,255,255,.10);
    --muted: rgba(255,255,255,.72);
  }

  /* Sidebar: Ultra Corporate + High-Tech Military */
  .main-sidebar.cmd-sidebar{
    background: rgba(0,0,0,.48) !important;
    border-right: 1px solid rgba(255,255,255,.08);
    backdrop-filter: blur(12px);
  }

  .cmd-brand-link{
    border-bottom: 1px solid rgba(255,255,255,.08) !important;
    background: rgba(0,0,0,.22) !important;
    display:flex;
    align-items:center;
    gap:10px;
    padding: 12px 14px !important;
  }
  .cmd-brand-link img{
    width:34px; height:34px; object-fit:contain;
    filter: drop-shadow(0 0 10px rgba(0,229,255,.16));
  }
  .cmd-brand-text{
    display:flex; flex-direction:column;
    line-height:1.05;
  }
  .cmd-brand-text .name{
    font-weight:900;
    letter-spacing:.9px;
    text-transform:uppercase;
    color:#fff;
    font-size:13px;
  }
  .cmd-brand-text .tag{
    margin-top:3px;
    color: rgba(255,255,255,.65);
    font-size:11px;
    letter-spacing:.3px;
  }

  .cmd-user-panel{
    padding: 12px 14px;
    border-bottom: 1px solid rgba(255,255,255,.08);
  }
  .cmd-user-card{
    border:1px solid rgba(255,255,255,.10);
    background: rgba(255,255,255,.04);
    border-radius: 16px;
    padding: 12px;
    position:relative;
    overflow:hidden;
  }
  .cmd-user-card:before{
    content:"";
    position:absolute; inset:0;
    background: radial-gradient(420px 160px at 20% 0%, rgba(0,229,255,.12), transparent 65%);
    opacity:.75;
    pointer-events:none;
  }
  .cmd-user-top{
    position:relative;
    display:flex;
    gap:10px;
    align-items:center;
  }
  .cmd-avatar{
    width:40px; height:40px;
    border-radius: 14px;
    display:flex; align-items:center; justify-content:center;
    border:1px solid rgba(0,229,255,.18);
    background: rgba(0,229,255,.08);
    color: var(--hud);
    flex: 0 0 auto;
  }
  .cmd-user-info{
    min-width:0;
  }
  .cmd-user-name{
    font-weight:900;
    letter-spacing:.4px;
    color:#fff;
    font-size:13px;
    white-space:nowrap;
    overflow:hidden;
    text-overflow:ellipsis;
  }
  .cmd-user-role{
    margin-top:4px;
    display:flex; gap:8px; align-items:center; flex-wrap:wrap;
    color: rgba(255,255,255,.65);
    font-size:11px;
    letter-spacing:.4px;
    text-transform:uppercase;
  }
  .cmd-dot{ width:8px; height:8px; border-radius:50%; background: var(--hud2); box-shadow:0 0 10px rgba(42,255,122,.6); }
  .cmd-dot.hud{ background: var(--hud); box-shadow:0 0 10px rgba(0,229,255,.6); }
  .cmd-dot.gold{ background: var(--gold); box-shadow:0 0 10px rgba(201,162,77,.45); }

  .cmd-pills{
    position:relative;
    margin-top:10px;
    display:flex; gap:8px; flex-wrap:wrap;
  }
  .cmd-pill{
    font-size:11px;
    padding:6px 8px;
    border-radius:999px;
    border:1px solid rgba(255,255,255,.12);
    background: rgba(0,0,0,.18);
    color: rgba(255,255,255,.82);
    display:flex;
    align-items:center;
    gap:7px;
    white-space:nowrap;
  }

  /* Menu section headers */
  .cmd-section{
    padding: 10px 14px 6px;
    color: rgba(255,255,255,.55);
    font-size:11px;
    letter-spacing:1.2px;
    text-transform:uppercase;
  }

  /* Nav items */
  .nav-sidebar .nav-link{
    border-radius: 14px;
    margin: 2px 10px;
    color: rgba(255,255,255,.78) !important;
    transition: .18s ease;
  }
  .nav-sidebar .nav-link:hover{
    background: rgba(255,255,255,.06) !important;
    color:#fff !important;
    transform: translateX(1px);
  }
  .nav-sidebar .nav-link.active{
    background: rgba(0,229,255,.14) !important;
    border: 1px solid rgba(0,229,255,.18);
    color:#fff !important;
  }
  .nav-sidebar .nav-icon{
    color: rgba(255,255,255,.72) !important;
  }
  .nav-sidebar .nav-link.active .nav-icon{
    color: var(--hud) !important;
  }

  /* Treeview open styling */
  .nav-sidebar .menu-open > .nav-link{
    background: rgba(255,255,255,.05) !important;
    border: 1px solid rgba(255,255,255,.08);
  }
  .nav-treeview{
    padding-left: 6px;
  }
  .nav-treeview .nav-link{
    margin: 2px 12px;
    border-radius: 12px;
    font-size: 13px;
  }

  /* Make sidebar scroll elegant */
  .sidebar{
    scrollbar-width: thin;
    scrollbar-color: rgba(255,255,255,.18) transparent;
  }
  .sidebar::-webkit-scrollbar{ width:8px; }
  .sidebar::-webkit-scrollbar-thumb{
    background: rgba(255,255,255,.12);
    border-radius: 10px;
  }
</style>

<aside class="main-sidebar cmd-sidebar elevation-4">
  <!-- Brand -->
  <a href="<?= htmlspecialchars($homeUrl) ?>" class="brand-link cmd-brand-link">
    <img src="<?= BASE_URL ?>/assets/image/logo.jpg" alt="<?= APP_NAME ?>">
    <div class="cmd-brand-text">
      <div class="name"><?= htmlspecialchars(APP_NAME) ?></div>
      <div class="tag">Command Console</div>
    </div>
  </a>

  <!-- Sidebar -->
  <div class="sidebar">
    <!-- User panel -->
    <div class="cmd-user-panel">
      <div class="cmd-user-card">
        <div class="cmd-user-top">
          <div class="cmd-avatar">
            <i class="fas fa-user-shield"></i>
          </div>
          <div class="cmd-user-info">
            <div class="cmd-user-name"><?= htmlspecialchars($me['full_name'] ?? 'User') ?></div>
            <div class="cmd-user-role">
              <span class="cmd-dot hud"></span>
              <span><?= htmlspecialchars($displayRole) ?></span>
            </div>
          </div>
        </div>

        <div class="cmd-pills">
          <div class="cmd-pill"><span class="cmd-dot hud"></span> Online</div>
          <div class="cmd-pill"><span class="cmd-dot"></span> Live</div>
          <div class="cmd-pill"><span class="cmd-dot gold"></span> Secure</div>
        </div>
      </div>
    </div>

    <nav class="mt-2">
      <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">

        <!-- COMMON -->
        <div class="cmd-section">Console</div>
        <li class="nav-item">
          <a class="nav-link <?= active('/dashboard.php') ?>" href="<?= htmlspecialchars($homeUrl) ?>">
            <i class="nav-icon fas fa-tachometer-alt"></i>
            <p>Dashboard</p>
          </a>
        </li>

        <?php if (anyRole($roles, ['admin','hr'])): ?>
          <div class="cmd-section">People</div>
          <li class="nav-item">
            <a class="nav-link <?= active('/users/') ?>" href="<?= BASE_URL ?>/users/index.php">
              <i class="nav-icon fas fa-users"></i>
              <p>Users</p>
            </a>
          </li>
        <?php endif; ?>

        <?php if (anyRole($roles, ['admin','manager'])): ?>
          <div class="cmd-section">Clients & Sites</div>
          <li class="nav-item">
            <a class="nav-link <?= active('/clients/') ?>" href="<?= BASE_URL ?>/clients/index.php">
              <i class="nav-icon fas fa-building"></i>
              <p>Clients</p>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link <?= active('/sites/') ?>" href="<?= BASE_URL ?>/sites/index.php">
              <i class="nav-icon fas fa-map-marked-alt"></i>
              <p>Sites</p>
            </a>
          </li>
        <?php endif; ?>

        <?php if (anyRole($roles, ['admin','manager','supervisor','controller'])): ?>
          <div class="cmd-section">Operations</div>
          <li class="nav-item">
            <a class="nav-link <?= active('/roster/') ?>" href="<?= BASE_URL ?>/roster/index.php">
              <i class="nav-icon fas fa-calendar-alt"></i>
              <p>Roster</p>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link <?= active('/attendance/') ?>" href="<?= BASE_URL ?>/attendance/index.php">
              <i class="nav-icon fas fa-user-clock"></i>
              <p>Attendance</p>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link <?= active('/incidents/') ?>" href="<?= BASE_URL ?>/incidents/index.php">
              <i class="nav-icon fas fa-exclamation-triangle"></i>
              <p>Incidents</p>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link <?= active('/patrol-routes/') ?>" href="<?= BASE_URL ?>/patrol-routes/index.php">
              <i class="nav-icon fas fa-route"></i>
              <p>Patrol Routes</p>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link <?= active('/leaves/') ?>" href="<?= BASE_URL ?>/leaves/index.php">
              <i class="nav-icon fas fa-plane-departure"></i>
              <p>Leaves</p>
            </a>
          </li>
        <?php endif; ?>

        <?php if (hasRole($roles, 'guard')): ?>
          <div class="cmd-section">My Portal</div>
          <li class="nav-item">
            <a class="nav-link <?= active('/guard/my-shifts.php') ?>" href="<?= BASE_URL ?>/guard/my-shifts.php">
              <i class="nav-icon fas fa-calendar"></i>
              <p>My Shifts</p>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link <?= active('/guard/my-attendance.php') ?>" href="<?= BASE_URL ?>/guard/my-attendance.php">
              <i class="nav-icon fas fa-user-clock"></i>
              <p>My Attendance</p>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link <?= active('/guard/report-incident.php') ?>" href="<?= BASE_URL ?>/guard/report-incident.php">
              <i class="nav-icon fas fa-exclamation-circle"></i>
              <p>Report Incident</p>
            </a>
          </li>

          <li class="nav-item <?= openMenu('/guard/patrol') ?>">
            <a href="#" class="nav-link <?= active('/guard/patrol') ?>">
              <i class="nav-icon fas fa-route"></i>
              <p>
                Patrol
                <i class="right fas fa-angle-left"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a class="nav-link <?= active('/guard/patrol-dashboard.php') ?>" href="<?= BASE_URL ?>/guard/patrol-dashboard.php">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Patrol Dashboard</p>
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link <?= active('/guard/my-patrols.php') ?>" href="<?= BASE_URL ?>/guard/my-patrols.php">
                  <i class="far fa-circle nav-icon"></i>
                  <p>My Patrol History</p>
                </a>
              </li>
            </ul>
          </li>
        <?php endif; ?>

        <div class="cmd-section">System</div>
        <li class="nav-item">
          <a class="nav-link" href="<?= BASE_URL ?>/logout.php">
            <i class="nav-icon fas fa-sign-out-alt"></i>
            <p>Logout</p>
          </a>
        </li>

      </ul>
    </nav>
  </div>
</aside>