<?php
session_start();
require_once __DIR__ . '/config/database.php';

$db = Database::connect();

$booking = null;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $ref = trim($_POST['booking_reference']);
    $email = trim($_POST['email']);

    $stmt = $db->prepare("
        SELECT b.*, s.service_name, c.name, c.email
        FROM bookings b
        JOIN services s ON s.id = b.service_id
        JOIN customers c ON c.id = b.customer_id
        WHERE b.booking_reference = ? AND c.email = ?
        LIMIT 1
    ");
    $stmt->execute([$ref, $email]);

    $booking = $stmt->fetch();

    if (!$booking) {
        $error = "Booking not found. Please check your reference and email.";
    }
}
?>

<?php require_once __DIR__ . '/includes/header.php'; ?>

<section class="section-padding">
<div class="container">
<div class="row justify-content-center">
<div class="col-lg-8">

<div class="booking-card p-5">

<h4 class="gold-text mb-4">Retrieve Your Booking</h4>

<?php if (!$booking): ?>

<form method="POST">

<div class="form-group">
<label>Booking Reference</label>
<input type="text"
class="form-control"
name="booking_reference"
required>
</div>

<div class="form-group">
<label>Email Address</label>
<input type="email"
class="form-control"
name="email"
required>
</div>

<?php if ($error): ?>
<div class="alert alert-danger">
<?php echo $error; ?>
</div>
<?php endif; ?>

<button type="submit"
class="btn btn-gold btn-block">
View Booking
</button>

</form>

<?php else: ?>

<hr>

<h5 class="gold-text">
Booking Reference: <?php echo $booking['booking_reference']; ?>
</h5>

<p><strong>Service:</strong> <?php echo $booking['service_name']; ?></p>
<p><strong>Status:</strong> <?php echo ucfirst($booking['status']); ?></p>
<p><strong>Pickup:</strong> <?php echo $booking['pickup_address']; ?></p>
<p><strong>Dropoff:</strong> <?php echo $booking['dropoff_address']; ?></p>
<p><strong>Date:</strong>
<?php echo date('d M Y H:i',
strtotime($booking['pickup_datetime'])); ?>
</p>

<?php if ($booking['flight_number']): ?>
<p><strong>Flight:</strong> <?php echo $booking['flight_number']; ?></p>
<?php endif; ?>

<p><strong>Total:</strong>
<span class="gold-text">
$<?php echo number_format($booking['final_price'],2); ?>
</span>
</p>

<hr>

<div class="mt-4">

<?php if ($booking['status'] === 'pending'): ?>
<a href="edit_booking.php?ref=<?php echo $booking['booking_reference']; ?>"
class="btn btn-gold">
Modify Booking
</a>
<?php endif; ?>

<a href="index.php"
class="btn btn-outline-light ml-2">
Back Home
</a>

</div>

<?php endif; ?>

</div>
</div>
</div>
</div>
</section>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
