<?php
require_once __DIR__ . '/config/database.php';

$db = Database::connect();

$ref = $_GET['ref'] ?? '';

if (!$ref) {
    die('Invalid booking reference.');
}

$stmt = $db->prepare("
    SELECT b.*, s.service_name, c.name, c.email
    FROM bookings b
    JOIN services s ON s.id = b.service_id
    JOIN customers c ON c.id = b.customer_id
    WHERE b.booking_reference = ?
    LIMIT 1
");
$stmt->execute([$ref]);
$booking = $stmt->fetch();

if (!$booking) {
    die('Booking not found.');
}
?>

<?php require_once __DIR__ . '/includes/header.php'; ?>

<section class="section-padding">
    <div class="container">

        <div class="row justify-content-center">
            <div class="col-lg-8">

                <div class="booking-card p-5 text-center" data-aos="fade-up">

                    <div class="mb-4">
                        <i class="fas fa-check-circle"
                           style="font-size:60px; color:#C9A24D;"></i>
                    </div>

                    <h2 class="gold-text mb-3">
                        Booking Confirmed
                    </h2>

                    <p class="text-muted mb-4">
                        Thank you for choosing Exclusive Concierge.
                        Your executive transfer has been successfully reserved.
                    </p>

                    <hr class="my-4">

                    <h5>Booking Reference</h5>
                    <h3 class="gold-text mb-4">
                        <?php echo htmlspecialchars($booking['booking_reference']); ?>
                    </h3>

                    <div class="text-left mt-4">

                        <p><strong>Service:</strong>
                            <?php echo htmlspecialchars($booking['service_name']); ?>
                        </p>

                        <p><strong>Pickup:</strong>
                            <?php echo htmlspecialchars($booking['pickup_address']); ?>
                        </p>

                        <p><strong>Drop-off:</strong>
                            <?php echo htmlspecialchars($booking['dropoff_address']); ?>
                        </p>

                        <p><strong>Date & Time:</strong>
                            <?php echo date('d M Y, H:i',
                                strtotime($booking['pickup_datetime'])); ?>
                        </p>

                        <?php if (!empty($booking['flight_number'])): ?>
                            <p><strong>Flight:</strong>
                                <?php echo htmlspecialchars($booking['flight_number']); ?>
                            </p>
                        <?php endif; ?>

                        <?php if (!empty($booking['hours'])): ?>
                            <p><strong>Hours:</strong>
                                <?php echo htmlspecialchars($booking['hours']); ?>
                            </p>
                        <?php endif; ?>

                        <hr>

                        <p class="mt-3">
                            <strong>Total Paid:</strong>
                            <span class="gold-text">
                                $<?php echo number_format($booking['final_price'], 2); ?>
                            </span>
                        </p>

                    </div>

                    <div class="mt-5">
                        <a href="edit_booking.php?ref=<?php echo $booking['booking_reference']; ?>"
                           class="btn btn-outline-light mt-3">
                           Modify Booking
                        </a>

                    </div>

                </div>

            </div>
        </div>

    </div>
</section>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
