<?php
session_start();

require_once __DIR__ . '/../config/app.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Our Services | Exclusive Concierge</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Premium airport transfers, limousine services and executive concierge coordination across Singapore.">

    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/public.css">
</head>

<body class="bg-midnight text-light">

<!-- NAVBAR -->
<nav class="navbar navbar-expand-lg navbar-dark bg-midnight fixed-top shadow-sm">
    <div class="container">
        <a class="navbar-brand font-weight-bold" href="index.php">
            <span class="text-gold">Exclusive</span> Concierge
        </a>

        <button class="navbar-toggler" type="button" data-toggle="collapse"
                data-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
                <li class="nav-item"><a class="nav-link active text-gold" href="#">Services</a></li>
                <li class="nav-item"><a class="nav-link" href="fleet.php">Fleet</a></li>
                <li class="nav-item"><a class="nav-link" href="contact.php">Contact</a></li>
                <li class="nav-item ml-3">
                    <a href="booking.php" class="btn btn-gold btn-sm">Book Now</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<div style="height:80px;"></div>

<!-- HERO SECTION -->
<section class="py-5 bg-dark-slate text-center">
    <div class="container">
        <h1 class="display-4 font-weight-bold">
            Our <span class="text-gold">Services</span>
        </h1>
        <p class="lead mt-3">
            Executive mobility and concierge solutions designed for precision, discretion, and excellence.
        </p>
    </div>
</section>


<!-- SERVICES GRID -->
<section class="section-padding bg-midnight">
    <div class="container">

        <div class="row">

            <!-- Airport Arrival -->
            <div class="col-lg-4 mb-4">
                <div class="service-detail-card p-4 h-100">
                    <i class="fas fa-plane-arrival fa-2x text-gold mb-3"></i>
                    <h4>Airport Arrival</h4>
                    <p>
                        Professional meet & greet service at Singapore Changi Airport.
                        Seamless coordination and executive reception.
                    </p>
                    <h5 class="text-gold">$65</h5>
                    <a href="booking.php?service=1" class="btn btn-outline-gold btn-sm mt-2">
                        Book Now
                    </a>
                </div>
            </div>

            <!-- Airport Departure -->
            <div class="col-lg-4 mb-4">
                <div class="service-detail-card p-4 h-100">
                    <i class="fas fa-plane-departure fa-2x text-gold mb-3"></i>
                    <h4>Airport Departure</h4>
                    <p>
                        Pickup from any Singapore zone to airport.
                        Zone-based pricing for transparent calculation.
                    </p>
                    <h5 class="text-gold">From $60</h5>
                    <a href="booking.php?service=2" class="btn btn-outline-gold btn-sm mt-2">
                        Book Now
                    </a>
                </div>
            </div>

            <!-- Point to Point -->
            <div class="col-lg-4 mb-4">
                <div class="service-detail-card p-4 h-100">
                    <i class="fas fa-map-marker-alt fa-2x text-gold mb-3"></i>
                    <h4>Point-to-Point Transfer</h4>
                    <p>
                        Direct transfer between any two locations in Singapore.
                        Efficient and punctual executive service.
                    </p>
                    <h5 class="text-gold">$65</h5>
                    <a href="booking.php?service=3" class="btn btn-outline-gold btn-sm mt-2">
                        Book Now
                    </a>
                </div>
            </div>

            <!-- City Tour -->
            <div class="col-lg-4 mb-4">
                <div class="service-detail-card p-4 h-100">
                    <i class="fas fa-city fa-2x text-gold mb-3"></i>
                    <h4>City Tour Package</h4>
                    <p>
                        Curated sightseeing experience with professional chauffeur.
                        Ideal for business guests and VIP visitors.
                    </p>
                    <h5 class="text-gold">$120</h5>
                    <a href="booking.php?service=4" class="btn btn-outline-gold btn-sm mt-2">
                        Book Now
                    </a>
                </div>
            </div>

            <!-- Limousine -->
            <div class="col-lg-4 mb-4">
                <div class="service-detail-card p-4 h-100">
                    <i class="fas fa-car-side fa-2x text-gold mb-3"></i>
                    <h4>Limousine Service</h4>
                    <p>
                        Luxury transport for corporate events, dignitaries,
                        and executive movements.
                    </p>
                    <h5 class="text-gold">$120</h5>
                    <a href="booking.php?service=5" class="btn btn-outline-gold btn-sm mt-2">
                        Book Now
                    </a>
                </div>
            </div>

            <!-- Hourly -->
            <div class="col-lg-4 mb-4">
                <div class="service-detail-card p-4 h-100">
                    <i class="fas fa-clock fa-2x text-gold mb-3"></i>
                    <h4>Hourly Booking</h4>
                    <p>
                        Flexible executive chauffeur service.
                        $15 base + $15 per hour.
                    </p>
                    <h5 class="text-gold">From $15</h5>
                    <a href="booking.php?service=6" class="btn btn-outline-gold btn-sm mt-2">
                        Book Now
                    </a>
                </div>
            </div>

        </div>
    </div>
</section>


<!-- WHY CHOOSE US -->
<section class="py-5 bg-dark-slate text-center">
    <div class="container">
        <h3 class="text-gold mb-4">Why Choose Exclusive Concierge</h3>
        <p class="lead">
            Discretion. Precision. Reliability.  
            We operate with uncompromising standards to deliver seamless executive mobility.
        </p>
    </div>
</section>


<!-- FOOTER -->
<footer class="bg-midnight text-center py-4">
    <div class="container">
        <p class="mb-1">&copy; <?php echo date('Y'); ?> Exclusive Concierge</p>
        <small class="text-muted">
            Premium Transport & Concierge Services | Singapore
        </small>
    </div>
</footer>

<script src="assets/vendor/jquery/jquery.min.js"></script>
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

</body>
</html>
