<?php
declare(strict_types=1);

class Translator
{
    private static string $locale = 'en';
    private static array $translations = [];

    public static function setLocale(string $locale): void
    {
        self::$locale = $locale;
        self::load();
    }

    private static function load(): void
    {
        $file = __DIR__ . "/../resources/lang/" . self::$locale . ".php";

        if (file_exists($file)) {
            self::$translations = require $file;
        } else {
            self::$translations = [];
        }
    }

    public static function get(string $key): string
    {
        return self::$translations[$key] ?? $key;
    }
}

/*
|--------------------------------------------------------------------------
| GLOBAL FUNCTION
|--------------------------------------------------------------------------
*/

function __($key): string
{
    return Translator::get($key);
}
