<?php

session_start();

require_once '../../app/controllers/BookingController.php';

header('Content-Type: application/json');

// CSRF Check
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid CSRF token.'
    ]);
    exit;
}

// Basic validation
$required = ['service_id','name','email','pickup_address','pickup_datetime'];

foreach ($required as $field) {
    if (empty($_POST[$field])) {
        echo json_encode([
            'status' => 'error',
            'message' => "Missing field: $field"
        ]);
        exit;
    }
}

$controller = new BookingController();

$response = $controller->create($_POST);

echo json_encode($response);
