<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Exclusive Concierge | Premium Executive Mobility</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">

    <!-- Bootstrap 4.6 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Custom Global Styles -->
    <style>
        /* =====================================
           Ultra Executive Global Header Style
        ====================================== */

        body {
            background-color: #0B0F19;
            color: #E5E7EB;
            font-family: 'Montserrat', sans-serif;
        }

        .navbar {
            transition: all 0.4s ease;
            padding: 20px 0;
            background: rgba(11, 15, 25, 0.85);
            backdrop-filter: blur(10px);
        }

        .navbar.scrolled {
            padding: 10px 0;
            background: #0B0F19;
            box-shadow: 0 5px 20px rgba(0,0,0,0.5);
        }

        .navbar-brand {
            font-family: 'Playfair Display', serif;
            font-size: 26px;
            font-weight: 700;
            color: #C9A24D !important;
            letter-spacing: 1px;
        }

        .navbar-nav .nav-link {
            color: #E5E7EB !important;
            margin-left: 25px;
            font-weight: 500;
            position: relative;
            transition: all 0.3s ease;
        }

        .navbar-nav .nav-link:hover {
            color: #C9A24D !important;
        }

        .navbar-nav .nav-link::after {
            content: "";
            position: absolute;
            width: 0;
            height: 2px;
            bottom: -6px;
            left: 0;
            background-color: #C9A24D;
            transition: width 0.3s ease;
        }

        .navbar-nav .nav-link:hover::after {
            width: 100%;
        }

        .btn-gold-nav {
            background-color: #C9A24D;
            color: #0B0F19;
            font-weight: 600;
            border-radius: 30px;
            padding: 8px 22px;
            margin-left: 30px;
            transition: all 0.3s ease;
        }

        .btn-gold-nav:hover {
            background-color: #b8913f;
            color: #ffffff;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(201,162,77,0.4);
        }

        .navbar-toggler {
            border: none;
        }

        .navbar-toggler:focus {
            outline: none;
        }

        .navbar-toggler-icon {
            background-image: none;
            width: 25px;
            height: 2px;
            background-color: #C9A24D;
            position: relative;
        }

        .navbar-toggler-icon::before,
        .navbar-toggler-icon::after {
            content: "";
            position: absolute;
            width: 25px;
            height: 2px;
            background-color: #C9A24D;
            left: 0;
        }

        .navbar-toggler-icon::before {
            top: -8px;
        }

        .navbar-toggler-icon::after {
            top: 8px;
        }
    </style>
</head>

<body>

<!-- NAVIGATION -->
<nav class="navbar navbar-expand-lg fixed-top">
    <div class="container">

        <a class="navbar-brand" href="index.php">
            Exclusive Concierge
        </a>

        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarContent">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse justify-content-end" id="navbarContent">
            <ul class="navbar-nav align-items-center">

                <li class="nav-item">
                    <a class="nav-link" href="index.php">Home</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#services">Services</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#fleet">Fleet</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#concierge">Concierge</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#contact">Contact</a>
                </li>

                <li class="nav-item">
                    <a href="booking.php" class="btn btn-gold-nav">
                        Book Now
                    </a>
                </li>

            </ul>
        </div>

    </div>
</nav>

<!-- Spacer to prevent content overlap -->
<div style="height:100px;"></div>

<script>
/* =====================================
   Scroll Effect (Shrink + Solid Background)
====================================== */
window.addEventListener("scroll", function() {
    const navbar = document.querySelector(".navbar");
    if (window.scrollY > 50) {
        navbar.classList.add("scrolled");
    } else {
        navbar.classList.remove("scrolled");
    }
});
</script>
