<?php

require_once __DIR__ . '/../services/PermissionService.php';

class PermissionMiddleware extends Middleware
{
    private string $permission;

    public function __construct(string $permission)
    {
        $this->permission = $permission;
    }

    public function handle(): void
    {
        session_start();

        if (!isset($_SESSION['admin_id'])) {
            header("Location: /login");
            exit;
        }

        if (!PermissionService::hasPermission(
            $_SESSION['admin_id'],
            $this->permission
        )) {
            http_response_code(403);
            die("Forbidden: Permission denied.");
        }
    }
}
