<?php
declare(strict_types=1);

/*
|--------------------------------------------------------------------------
| RESPONSE HELPERS
|--------------------------------------------------------------------------
*/

function jsonResponse(array $data, int $status = 200): void
{
    http_response_code($status);
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

/*
|--------------------------------------------------------------------------
| SANITIZATION
|--------------------------------------------------------------------------
*/

function e(string $value): string
{
    return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
}

/*
|--------------------------------------------------------------------------
| REDIRECT
|--------------------------------------------------------------------------
*/

function redirect(string $path): void
{
    header("Location: {$path}");
    exit;
}

/*
|--------------------------------------------------------------------------
| AUTH CHECK
|--------------------------------------------------------------------------
*/

function isAuthenticated(): bool
{
    return isset($_SESSION['admin_id']);
}

/*
|--------------------------------------------------------------------------
| GENERATE RANDOM STRING
|--------------------------------------------------------------------------
*/

function randomString(int $length = 32): string
{
    return bin2hex(random_bytes($length / 2));
}

/*
|--------------------------------------------------------------------------
| PASSWORD HASHING
|--------------------------------------------------------------------------
*/

function hashPassword(string $password): string
{
    return password_hash($password, PASSWORD_DEFAULT);
}

function verifyPassword(string $password, string $hash): bool
{
    return password_verify($password, $hash);
}
