<?php
require_once 'includes/config.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $email = $_POST['email'];
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? AND role = 'admin' LIMIT 1");
    $stmt->execute([$email]);
    $admin = $stmt->fetch();

    if ($admin && password_verify($password, $admin['password_hash'])) {

        $_SESSION['admin_id'] = $admin['id'];
        $_SESSION['admin_name'] = $admin['name'];

        header("Location: dashboard.php");
        exit;
    } else {
        $error = "Invalid credentials.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Exclusive Concierge | Admin Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600&family=Montserrat:wght@300;400;500&display=swap" rel="stylesheet">

<style>
:root {
    --primary: #0B0F19;
    --secondary: #1F2937;
    --accent: #C9A24D;
    --text: #E5E7EB;
    --muted: #9CA3AF;
}

* {
    box-sizing: border-box;
}

body {
    margin: 0;
    font-family: 'Montserrat', sans-serif;
    background: linear-gradient(135deg, #0B0F19, #1F2937);
    height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--text);
    overflow: hidden;
}

body::before {
    content: "";
    position: absolute;
    width: 600px;
    height: 600px;
    background: radial-gradient(circle, rgba(201,162,77,0.15) 0%, transparent 70%);
    top: -150px;
    right: -150px;
}

.login-container {
    width: 400px;
    backdrop-filter: blur(20px);
    background: rgba(31,41,55,0.65);
    border: 1px solid rgba(201,162,77,0.3);
    border-radius: 16px;
    padding: 40px;
    box-shadow: 0 0 40px rgba(0,0,0,0.6);
}

.brand-title {
    font-family: 'Playfair Display', serif;
    font-size: 28px;
    text-align: center;
    margin-bottom: 8px;
}

.brand-subtitle {
    text-align: center;
    font-size: 14px;
    color: var(--muted);
    margin-bottom: 30px;
}

input {
    width: 100%;
    padding: 14px;
    margin-bottom: 18px;
    border-radius: 8px;
    border: 1px solid #374151;
    background: #0f172a;
    color: var(--text);
    font-size: 14px;
    transition: 0.3s;
}

input:focus {
    border-color: var(--accent);
    outline: none;
    box-shadow: 0 0 8px rgba(201,162,77,0.5);
}

button {
    width: 100%;
    padding: 14px;
    border: none;
    border-radius: 8px;
    background: var(--accent);
    color: #000;
    font-weight: 600;
    letter-spacing: 1px;
    cursor: pointer;
    transition: 0.3s;
}

button:hover {
    background: #d8b868;
    box-shadow: 0 0 12px rgba(201,162,77,0.7);
}

.error-box {
    background: rgba(220,53,69,0.1);
    border: 1px solid rgba(220,53,69,0.3);
    padding: 10px;
    border-radius: 6px;
    margin-bottom: 15px;
    font-size: 13px;
}

.footer-text {
    margin-top: 25px;
    text-align: center;
    font-size: 12px;
    color: var(--muted);
}

.footer-text a {
    color: var(--accent);
    text-decoration: none;
}

.footer-text a:hover {
    text-decoration: underline;
}
</style>
</head>

<body>

<div class="login-container">

    <div class="brand-title">Exclusive Concierge</div>
    <div class="brand-subtitle">Executive Control Panel</div>

    <?php if ($error): ?>
        <div class="error-box"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" autocomplete="off">
        <input type="email" name="email" placeholder="Email Address" required>
        <input type="password" name="password" placeholder="Password" required>
        <button type="submit">SIGN IN</button>
    </form>

    <div class="footer-text">
        Secure Admin Access • Confidential System
    </div>

</div>

</body>
</html>
