<?php
require_once '../app/db.php';
require_once '../vendor/autoload.php';

\Stripe\Stripe::setApiKey("YOUR_STRIPE_SECRET_KEY");

$booking_id = $_GET['id'];

$stmt = $pdo->prepare("SELECT * FROM bookings WHERE id=?");
$stmt->execute([$booking_id]);
$booking = $stmt->fetch();

$session = \Stripe\Checkout\Session::create([
    'payment_method_types' => ['card'],
    'line_items' => [[
        'price_data' => [
            'currency' => 'sgd',
            'product_data' => [
                'name' => 'Exclusive Concierge Booking ' . $booking['booking_code'],
            ],
            'unit_amount' => $booking['estimated_price'] * 100,
        ],
        'quantity' => 1,
    ]],
    'mode' => 'payment',
    'success_url' => 'https://exclconcierge.cpforce.com.sg/public/stripe_success.php?session_id={CHECKOUT_SESSION_ID}',
    'cancel_url' => 'https://exclconcierge.cpforce.com.sg/public/payment.php?id='.$booking_id,
]);

$pdo->prepare("UPDATE bookings SET stripe_session_id=? WHERE id=?")
    ->execute([$session->id, $booking_id]);

header("Location: " . $session->url);
exit;
