<?php
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

require_once __DIR__ . '/../vendor/autoload.php';

define('JWT_SECRET', 'CHANGE_THIS_SECRET_KEY');

function generateJWT($driver_id) {
    $payload = [
        'iss' => 'exclusive-concierge',
        'iat' => time(),
        'exp' => time() + (60 * 60 * 24),
        'driver_id' => $driver_id
    ];
    return JWT::encode($payload, JWT_SECRET, 'HS256');
}

function validateJWT($token) {
    try {
        $decoded = JWT::decode($token, new Key(JWT_SECRET, 'HS256'));
        return $decoded->driver_id;
    } catch (Exception $e) {
        return false;
    }
}
