<?php
require 'middleware.php';

$data = json_decode(file_get_contents("php://input"), true);
$booking_id = $data['booking_id'];
$status = $data['status'];

$allowed = ['on_the_way','arrived','completed'];

if (!in_array($status, $allowed)) {
    http_response_code(400);
    echo json_encode(['error'=>'Invalid status']);
    exit;
}

$pdo->prepare("
UPDATE bookings
SET status=?
WHERE id=? AND driver_id=?
")->execute([$status, $booking_id, $driver_id]);

if ($status === 'completed') {
    $pdo->prepare("
    UPDATE bookings
    SET payment_status='paid'
    WHERE id=?
    ")->execute([$booking_id]);
}

echo json_encode(['success'=>true]);
