<?php 
require 'includes/auth.php'; 
require_once '../app/db.php';

if ($_SESSION['admin_role'] !== 'superadmin') {
    die("Access Denied");
}

$stmt = $pdo->query("SELECT * FROM system_settings");
$settings = [];

foreach ($stmt as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
?>

<?php include 'includes/header.php'; ?>
<?php include 'includes/sidebar.php'; ?>

<style>
.card-deluxe {
    background: #1F2937;
    border: 1px solid #2c3645;
    border-radius: 10px;
}
.gold-title {
    color: #C9A24D;
    font-weight: 600;
}
.form-control {
    background: #0B0F19;
    border: 1px solid #2c3645;
    color: #E5E7EB;
}
.form-control:focus {
    border-color: #C9A24D;
    box-shadow: none;
}
.btn-gold {
    background: #C9A24D;
    color: #0B0F19;
    font-weight: 600;
}
.btn-gold:hover {
    background: #b88f3f;
}
.logo-preview {
    background: #0B0F19;
    padding: 20px;
    text-align: center;
    border-radius: 8px;
}
hr {
    border-color: #2c3645;
}
</style>

<div class="content-wrapper">
<section class="content pt-4">
<div class="container-fluid">

<h3 class="gold-title mb-4">System Configuration Panel</h3>

<form id="settingsForm" enctype="multipart/form-data">

<!-- COMPANY -->
<div class="card card-deluxe mb-4">
<div class="card-header gold-title">Company Information</div>
<div class="card-body">
<div class="row">

<div class="col-md-8">

<div class="form-group">
<label>Company Name</label>
<input type="text" name="company_name"
class="form-control"
value="<?= $settings['company_name'] ?? '' ?>">
</div>

<div class="form-group">
<label>Email</label>
<input type="email" name="company_email"
class="form-control"
value="<?= $settings['company_email'] ?? '' ?>">
</div>

<div class="form-group">
<label>Phone</label>
<input type="text" name="company_phone"
class="form-control"
value="<?= $settings['company_phone'] ?? '' ?>">
</div>

<div class="form-group">
<label>Address</label>
<textarea name="company_address"
class="form-control"><?= $settings['company_address'] ?? '' ?></textarea>
</div>

</div>

<div class="col-md-4">
<div class="logo-preview">

<?php if(!empty($settings['company_logo'])): ?>
<img src="uploads/logo/<?= $settings['company_logo'] ?>"
style="max-height:120px;">
<?php else: ?>
<p class="text-muted">No logo uploaded</p>
<?php endif; ?>

<hr>

<input type="file" name="company_logo"
class="form-control">

<small class="text-muted">
JPG / PNG / SVG · Max 2MB
</small>

</div>
</div>

</div>
</div>
</div>

<!-- PAYMENT -->
<div class="card card-deluxe mb-4">
<div class="card-header gold-title">Payment Configuration</div>
<div class="card-body">

<div class="form-group">
<label>Stripe Public Key</label>
<input type="text" name="stripe_public_key"
class="form-control"
value="<?= $settings['stripe_public_key'] ?? '' ?>">
</div>

<div class="form-group">
<label>Stripe Secret Key</label>
<input type="password" name="stripe_secret_key"
class="form-control"
value="<?= $settings['stripe_secret_key'] ?? '' ?>">
</div>

<div class="form-group">
<label>PayNow UEN</label>
<input type="text" name="paynow_uen"
class="form-control"
value="<?= $settings['paynow_uen'] ?? '' ?>">
</div>

</div>
</div>

<!-- SYSTEM -->
<div class="card card-deluxe mb-4">
<div class="card-header gold-title">System Preferences</div>
<div class="card-body">

<div class="form-group">
<label>Currency</label>
<input type="text" name="currency"
class="form-control"
value="<?= $settings['currency'] ?? 'SGD' ?>">
</div>

<div class="form-group">
<label>Timezone</label>
<input type="text" name="timezone"
class="form-control"
value="<?= $settings['timezone'] ?? 'Asia/Singapore' ?>">
</div>

<div class="form-group">
<label>Auto Dispatch</label>
<select name="auto_dispatch" class="form-control">
<option value="0" <?= ($settings['auto_dispatch'] ?? '')=='0'?'selected':'' ?>>Disabled</option>
<option value="1" <?= ($settings['auto_dispatch'] ?? '')=='1'?'selected':'' ?>>Enabled</option>
</select>
</div>

</div>
</div>

<!-- SMTP -->
<div class="card card-deluxe mb-4">
<div class="card-header gold-title">SMTP Email Configuration</div>
<div class="card-body">
<div class="row">

<div class="col-md-6">

<div class="form-group">
<label>SMTP Host</label>
<input type="text" name="smtp_host"
class="form-control"
value="<?= $settings['smtp_host'] ?? '' ?>">
</div>

<div class="form-group">
<label>SMTP Port</label>
<input type="text" name="smtp_port"
class="form-control"
value="<?= $settings['smtp_port'] ?? '587' ?>">
</div>

<div class="form-group">
<label>Encryption</label>
<select name="smtp_encryption" class="form-control">
<option value="tls" <?= ($settings['smtp_encryption'] ?? '')=='tls'?'selected':'' ?>>TLS</option>
<option value="ssl" <?= ($settings['smtp_encryption'] ?? '')=='ssl'?'selected':'' ?>>SSL</option>
<option value="" <?= ($settings['smtp_encryption'] ?? '')==''?'selected':'' ?>>None</option>
</select>
</div>

<div class="form-group">
<label>SMTP Username</label>
<input type="text" name="smtp_username"
class="form-control"
value="<?= $settings['smtp_username'] ?? '' ?>">
</div>

<div class="form-group">
<label>SMTP Password</label>
<input type="password" name="smtp_password"
class="form-control"
value="<?= $settings['smtp_password'] ?? '' ?>">
</div>

</div>

<div class="col-md-6">

<div class="form-group">
<label>From Email</label>
<input type="email" name="smtp_from_email"
class="form-control"
value="<?= $settings['smtp_from_email'] ?? '' ?>">
</div>

<div class="form-group">
<label>From Name</label>
<input type="text" name="smtp_from_name"
class="form-control"
value="<?= $settings['smtp_from_name'] ?? '' ?>">
</div>

<hr>

<h6 class="gold-title">Send Test Email</h6>

<div class="form-group">
<input type="email" id="test_email"
class="form-control"
placeholder="Enter email to test">
</div>

<button type="button"
onclick="sendTestEmail()"
class="btn btn-gold btn-block">
Send Test Email
</button>

</div>

</div>
</div>
</div>

<button type="button"
onclick="saveSettings()"
class="btn btn-gold btn-lg">
Save Configuration
</button>

</form>

</div>
</section>
</div>

<script>
function saveSettings() {
    let formData = new FormData(
        document.getElementById("settingsForm")
    );

    fetch("api/update_settings.php", {
        method: "POST",
        body: formData
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            alert("Settings Updated Successfully");
            location.reload();
        } else {
            alert("Error: " + data.error);
        }
    });
}

function sendTestEmail() {
    let email = document.getElementById("test_email").value;

    if (!email) {
        alert("Enter email address.");
        return;
    }

    fetch("api/test_smtp.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify({ email: email })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            alert("Test Email Sent Successfully");
        } else {
            alert("Error: " + data.error);
        }
    });
}
</script>

<?php include 'includes/footer.php'; ?>
