<?php
require_once '../app/db.php';
session_start();

/*
|--------------------------------------------------------------------------
| Prevent Registration If Admin Exists
|--------------------------------------------------------------------------
*/
$stmt = $pdo->query("SELECT COUNT(*) FROM admins");
$adminCount = $stmt->fetchColumn();

if ($adminCount > 0) {
    die("Admin already registered. Registration disabled.");
}

$error = "";
$success = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name     = trim($_POST['name']);
    $email    = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm  = $_POST['confirm_password'];

    if (!$name || !$email || !$password) {
        $error = "All fields are required.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = "Invalid email format.";
    } elseif ($password !== $confirm) {
        $error = "Passwords do not match.";
    } elseif (strlen($password) < 8) {
        $error = "Password must be at least 8 characters.";
    } else {

        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

        $stmt = $pdo->prepare("
            INSERT INTO admins (name, email, password, role)
            VALUES (?, ?, ?, 'superadmin')
        ");

        try {
            $stmt->execute([$name, $email, $hashedPassword]);
            $success = "Super Admin created successfully. 
                        <a href='login.php'>Login Now</a>";
        } catch (Exception $e) {
            $error = "Registration failed. Email may already exist.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Exclusive Concierge | Admin Registration</title>

<link rel="stylesheet" 
href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">

<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

<style>
body {
    font-family: 'Montserrat', sans-serif;
    background: linear-gradient(
        rgba(11,15,25,0.95),
        rgba(11,15,25,0.95)
    ),
    url('../public/assets/images/hero.jpg') center/cover no-repeat;
    height: 100vh;
}

.register-wrapper {
    display: flex;
    height: 100vh;
}

.register-left {
    flex: 1;
    color: #C9A24D;
    display: flex;
    flex-direction: column;
    justify-content: center;
    padding: 80px;
}

.register-left h1 {
    font-weight: 600;
    font-size: 40px;
}

.register-left p {
    color: #9CA3AF;
    max-width: 420px;
}

.register-right {
    width: 460px;
    background: rgba(31,41,55,0.92);
    backdrop-filter: blur(10px);
    display: flex;
    align-items: center;
    padding: 40px;
}

.register-card {
    width: 100%;
}

.form-control {
    background: #0B0F19;
    border: 1px solid #1F2937;
    color: #E5E7EB;
}

.form-control:focus {
    border-color: #C9A24D;
    box-shadow: none;
}

.btn-gold {
    background: #C9A24D;
    color: #0B0F19;
    font-weight: 600;
}

.btn-gold:hover {
    background: #b88f3f;
    color: #0B0F19;
}

.register-title {
    color: #C9A24D;
    font-weight: 600;
    margin-bottom: 20px;
}

.footer-text {
    color: #6c757d;
    font-size: 12px;
    text-align: center;
    margin-top: 20px;
}
</style>

</head>
<body>

<div class="register-wrapper">

<div class="register-left d-none d-lg-flex">
    <h1>Exclusive Concierge</h1>
    <p>
        Establish the first Super Administrator account to securely
        manage bookings, drivers, payments, and executive operations.
    </p>
</div>

<div class="register-right">
<div class="register-card">

<h4 class="register-title">Create Super Admin</h4>

<?php if($error): ?>
<div class="alert alert-danger"><?= $error ?></div>
<?php endif; ?>

<?php if($success): ?>
<div class="alert alert-success"><?= $success ?></div>
<?php else: ?>

<form method="POST">

<div class="form-group">
<label>Full Name</label>
<input type="text" name="name"
class="form-control"
required>
</div>

<div class="form-group">
<label>Email Address</label>
<input type="email" name="email"
class="form-control"
required>
</div>

<div class="form-group">
<label>Password</label>
<input type="password" name="password"
class="form-control"
placeholder="Minimum 8 characters"
required>
</div>

<div class="form-group">
<label>Confirm Password</label>
<input type="password" name="confirm_password"
class="form-control"
required>
</div>

<button type="submit" class="btn btn-gold btn-block">
Register Super Admin
</button>

</form>

<?php endif; ?>

<div class="footer-text">
© <?= date('Y') ?> Exclusive Concierge
</div>

</div>
</div>

</div>

<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/jquery/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

</body>
</html>
