<?php
session_start();
require 'includes/audit_helper.php';
logAudit('Authentication','Admin Login');


// Clear session data
$_SESSION = [];

// Destroy session
session_destroy();

// Regenerate session ID
session_regenerate_id(true);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Logged Out | Exclusive Concierge</title>

<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">

<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

<style>
body {
    font-family: 'Montserrat', sans-serif;
    background: linear-gradient(
        rgba(11,15,25,0.95),
        rgba(11,15,25,0.95)
    ),
    url('../public/assets/images/hero.jpg') center/cover no-repeat;
    height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
}

.logout-card {
    background: rgba(31,41,55,0.95);
    padding: 50px;
    width: 420px;
    text-align: center;
    border-radius: 12px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.6);
}

.logout-card h2 {
    color: #C9A24D;
    font-weight: 600;
    margin-bottom: 15px;
}

.logout-card p {
    color: #9CA3AF;
    margin-bottom: 25px;
}

.btn-gold {
    background: #C9A24D;
    color: #0B0F19;
    font-weight: 600;
    border: none;
}

.btn-gold:hover {
    background: #b88f3f;
    color: #0B0F19;
}

.footer-text {
    margin-top: 25px;
    font-size: 12px;
    color: #6c757d;
}
</style>

<meta http-equiv="refresh" content="3;url=login.php">

</head>
<body>

<div class="logout-card">

<h2>Secure Logout Successful</h2>

<p>
Your administrative session has been securely terminated.<br>
Redirecting to login portal...
</p>

<a href="login.php" class="btn btn-gold btn-block">
Return to Login Now
</a>

<div class="footer-text">
© <?= date('Y') ?> Exclusive Concierge
</div>

</div>

</body>
</html>
