<?php require 'includes/auth.php'; ?>
<?php require_once '../app/db.php'; ?>

<?php include 'includes/header.php'; ?>
<?php include 'includes/sidebar.php'; ?>

<?php
$bookings = $pdo->query("
SELECT b.*, c.name
FROM bookings b
JOIN customers c ON b.customer_id=c.id
WHERE b.status='pending'
ORDER BY b.pickup_datetime ASC
");
?>

<div class="content-wrapper">
<section class="content pt-4">
<div class="container-fluid">

<h2>Dispatch Control Panel</h2>

<table class="table table-bordered">
<tr>
<th>Code</th>
<th>Customer</th>
<th>Pickup Time</th>
<th>Action</th>
</tr>

<?php foreach($bookings as $b): ?>
<tr>
<td><?= $b['booking_code'] ?></td>
<td><?= $b['name'] ?></td>
<td><?= $b['pickup_datetime'] ?></td>
<td>
<a href="dispatch_map.php?id=<?= $b['id'] ?>" 
class="btn btn-warning btn-sm">
Dispatch
</a>
</td>
</tr>
<?php endforeach; ?>

</table>

</div>
</section>
</div>

<?php include 'includes/footer.php'; ?>
