<?php
require 'includes/auth.php';
require_once '../app/db.php';

if ($_SESSION['admin_role'] !== 'superadmin') {
    die("Access denied.");
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$stmt = $pdo->prepare("SELECT * FROM admins WHERE id=?");
$stmt->execute([$id]);
$admin = $stmt->fetch();

if (!$admin) {
    die("Admin not found.");
}

$message = "";

/* ===== UPDATE ADMIN ===== */
if (isset($_POST['update_admin'])) {

    $name  = trim($_POST['name']);
    $email = trim($_POST['email']);
    $role  = $_POST['role'];

    // Prevent removing last superadmin
    if ($admin['role'] === 'superadmin' && $role !== 'superadmin') {

        $count = $pdo->query("
            SELECT COUNT(*) FROM admins WHERE role='superadmin'
        ")->fetchColumn();

        if ($count <= 1) {
            $message = "Cannot remove the last superadmin.";
        }
    }

    // Prevent self-demotion
    if ($admin['id'] == $_SESSION['admin_id'] &&
        $admin['role'] === 'superadmin' &&
        $role !== 'superadmin') {
        $message = "You cannot demote yourself.";
    }

    if (!$message) {

        $stmt = $pdo->prepare("
            UPDATE admins
            SET name=?, email=?, role=?
            WHERE id=?
        ");
        $stmt->execute([$name,$email,$role,$id]);

        $message = "Admin updated successfully.";
    }
}

/* ===== PASSWORD RESET ===== */
if (isset($_POST['reset_password'])) {

    $newPass = password_hash($_POST['new_password'], PASSWORD_DEFAULT);

    $pdo->prepare("
        UPDATE admins SET password=? WHERE id=?
    ")->execute([$newPass,$id]);

    $message = "Password updated successfully.";
}

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<style>
.content-wrapper {
    background: #0B0F19;
}

.card-luxury {
    background: linear-gradient(135deg,#1F2937,#0B0F19);
    border-left: 4px solid #C9A24D;
    color: #E5E7EB;
}

.btn-gold {
    background:#C9A24D;
    color:#0B0F19;
    font-weight:600;
}

.btn-gold:hover {
    background:#b88f3f;
    color:#0B0F19;
}

.form-control {
    background:#0B0F19;
    color:#E5E7EB;
    border:1px solid #1F2937;
}

.form-control:focus {
    border-color:#C9A24D;
    box-shadow:none;
}
</style>

<div class="content-wrapper">
<section class="content pt-4">
<div class="container-fluid">

<h3 class="text-warning mb-4">
Edit Admin: <?= htmlspecialchars($admin['name']) ?>
</h3>

<?php if($message): ?>
<div class="alert alert-info"><?= $message ?></div>
<?php endif; ?>

<div class="row">

<!-- EDIT DETAILS -->
<div class="col-md-6">
<div class="card card-luxury p-4">

<h5 class="mb-3">Admin Details</h5>

<form method="POST">

<div class="form-group">
<label>Name</label>
<input type="text"
name="name"
class="form-control"
value="<?= htmlspecialchars($admin['name']) ?>"
required>
</div>

<div class="form-group">
<label>Email</label>
<input type="email"
name="email"
class="form-control"
value="<?= htmlspecialchars($admin['email']) ?>"
required>
</div>

<div class="form-group">
<label>Role</label>
<select name="role" class="form-control">
<option value="manager"
<?= $admin['role']=='manager'?'selected':'' ?>>
Manager
</option>

<option value="superadmin"
<?= $admin['role']=='superadmin'?'selected':'' ?>>
Superadmin
</option>
</select>
</div>

<button type="submit"
name="update_admin"
class="btn btn-gold btn-block">
Update Admin
</button>

</form>

</div>
</div>

<!-- PASSWORD RESET -->
<div class="col-md-6">
<div class="card card-luxury p-4">

<h5 class="mb-3">Reset Password</h5>

<form method="POST">

<div class="form-group">
<label>New Password</label>
<input type="password"
name="new_password"
class="form-control"
required>
</div>

<button type="submit"
name="reset_password"
class="btn btn-gold btn-block">
Reset Password
</button>

</form>

</div>
</div>

</div>

<a href="admin_users.php"
class="btn btn-secondary mt-4">
← Back to Admin Users
</a>

</div>
</section>
</div>

<?php include 'includes/footer.php'; ?>
