<?php
require_once 'includes/config.php';

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    if ($password !== $confirm_password) {
        $error = "Passwords do not match.";
    } else {

        $check = $pdo->prepare("SELECT id FROM users WHERE email = ?");
        $check->execute([$email]);

        if ($check->rowCount() > 0) {
            $error = "Email already exists.";
        } else {

            $password_hash = password_hash($password, PASSWORD_BCRYPT);

            $stmt = $pdo->prepare("INSERT INTO users 
                (role, name, email, password_hash, status, created_at)
                VALUES ('admin', ?, ?, ?, 'active', NOW())");

            if ($stmt->execute([$name, $email, $password_hash])) {
                $message = "Administrator account created successfully.";
            } else {
                $error = "Registration failed. Please try again.";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Executive Admin Registration</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600&family=Montserrat:wght@400;500&display=swap" rel="stylesheet">

<style>
body {
    margin: 0;
    background: radial-gradient(circle at top right, #111827, #0B0F19);
    font-family: 'Montserrat', sans-serif;
    display: flex;
    align-items: center;
    justify-content: center;
    height: 100vh;
}

/* Card */
.card-wrapper {
    width: 460px;
}

.card-luxury {
    background: rgba(255,255,255,0.04);
    border: 1px solid rgba(201,162,77,0.25);
    backdrop-filter: blur(25px);
    border-radius: 18px;
    padding: 50px 45px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.6);
    transition: 0.4s ease;
}

.brand-title {
    font-family: 'Playfair Display', serif;
    font-size: 30px;
    color: #C9A24D;
    text-align: center;
    margin-bottom: 5px;
}

.brand-sub {
    text-align: center;
    color: #9CA3AF;
    font-size: 14px;
    margin-bottom: 35px;
}

/* Floating Form */
.form-group {
    position: relative;
    margin-bottom: 28px;
}

.form-control {
    width: 100%;
    background: transparent;
    border: none;
    border-bottom: 1px solid #374151;
    padding: 12px 0;
    font-size: 15px;
    color: #E5E7EB;
    outline: none;
    transition: 0.3s ease;
}

.form-control:focus {
    border-bottom: 1px solid #C9A24D;
}

.form-label {
    position: absolute;
    top: 12px;
    left: 0;
    color: #6B7280;
    font-size: 14px;
    transition: 0.3s ease;
    pointer-events: none;
}

.form-control:focus + .form-label,
.form-control:not(:placeholder-shown) + .form-label {
    top: -10px;
    font-size: 12px;
    color: #C9A24D;
}

/* Button */
.btn-gold {
    width: 100%;
    background: linear-gradient(90deg, #C9A24D, #d4af37);
    border: none;
    padding: 14px;
    border-radius: 10px;
    font-weight: 600;
    letter-spacing: 1px;
    color: #0B0F19;
    transition: 0.3s ease;
}

.btn-gold:hover {
    box-shadow: 0 0 18px rgba(201,162,77,0.8);
    transform: translateY(-2px);
}

/* Alerts */
.alert {
    padding: 12px;
    border-radius: 10px;
    margin-bottom: 20px;
    font-size: 14px;
}

.alert-success {
    background: rgba(34,197,94,0.1);
    border: 1px solid #22c55e;
    color: #22c55e;
}

.alert-danger {
    background: rgba(239,68,68,0.1);
    border: 1px solid #ef4444;
    color: #ef4444;
}

/* Footer */
.footer-note {
    margin-top: 18px;
    text-align: center;
    font-size: 12px;
    color: #6B7280;
}
</style>
</head>

<body>

<div class="card-wrapper">
    <div class="card-luxury">

        <div class="brand-title">Exclusive Concierge</div>
        <div class="brand-sub">Executive Administration Portal</div>

        <?php if ($message): ?>
            <div class="alert alert-success"><?= $message ?></div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>

        <form method="POST" autocomplete="off">

            <div class="form-group">
                <input type="text" name="name" class="form-control" placeholder=" " required>
                <label class="form-label">Full Name</label>
            </div>

            <div class="form-group">
                <input type="email" name="email" class="form-control" placeholder=" " required>
                <label class="form-label">Executive Email</label>
            </div>

            <div class="form-group">
                <input type="password" name="password" class="form-control" placeholder=" " required>
                <label class="form-label">Secure Password</label>
            </div>

            <div class="form-group">
                <input type="password" name="confirm_password" class="form-control" placeholder=" " required>
                <label class="form-label">Confirm Password</label>
            </div>

            <button type="submit" class="btn-gold">
                CREATE ADMINISTRATOR
            </button>

        </form>

        <div class="footer-note">
            Premium Mobility & Concierge System • Secure Access
        </div>

    </div>
</div>

</body>
</html>
