<?php
if (!isset($pdo)) {
    require_once __DIR__ . '/config.php';
}

$pendingBookings = $pdo->query("SELECT COUNT(*) FROM bookings WHERE status='pending'")->fetchColumn() ?? 0;
$onlineDrivers   = $pdo->query("SELECT COUNT(*) FROM drivers WHERE is_online=1")->fetchColumn() ?? 0;
?>

<!-- Navbar -->
<nav class="main-header navbar navbar-expand navbar-dark">

    <!-- Left navbar links -->
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button">
                <i class="fas fa-bars"></i>
            </a>
        </li>
    </ul>

    <!-- Center Title -->
    <span class="navbar-text ml-3" style="color:#C9A24D; font-weight:600;">
        Executive Control Center
    </span>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">

        <!-- Pending Bookings -->
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="fas fa-clipboard-list"></i>
                <?php if ($pendingBookings > 0): ?>
                    <span class="badge badge-warning navbar-badge">
                        <?= $pendingBookings ?>
                    </span>
                <?php endif; ?>
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <span class="dropdown-item dropdown-header">
                    <?= $pendingBookings ?> Pending Bookings
                </span>
                <div class="dropdown-divider"></div>
                <a href="bookings.php" class="dropdown-item">
                    <i class="fas fa-eye mr-2"></i> View Bookings
                </a>
            </div>
        </li>

        <!-- Online Drivers -->
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="fas fa-car"></i>
                <?php if ($onlineDrivers > 0): ?>
                    <span class="badge badge-success navbar-badge">
                        <?= $onlineDrivers ?>
                    </span>
                <?php endif; ?>
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <span class="dropdown-item dropdown-header">
                    <?= $onlineDrivers ?> Drivers Online
                </span>
                <div class="dropdown-divider"></div>
                <a href="drivers.php" class="dropdown-item">
                    <i class="fas fa-map-marker-alt mr-2"></i> Monitor Drivers
                </a>
            </div>
        </li>

        <!-- User Account Dropdown -->
        <?php if (isset($_SESSION['admin_name'])): ?>
        <li class="nav-item dropdown user-menu">
            <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">
                <i class="far fa-user"></i>
                <span class="d-none d-md-inline"><?= htmlspecialchars($_SESSION['admin_name']); ?></span>
            </a>
            <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-right">

                <li class="user-header" style="background:#1F2937;">
                    <p style="color:#C9A24D; font-weight:600;">
                        <?= htmlspecialchars($_SESSION['admin_name']); ?>
                    </p>
                    <small style="color:#9CA3AF;">Administrator</small>
                </li>

                <li class="user-footer d-flex justify-content-between">
                    <a href="profile.php" class="btn btn-sm btn-outline-light">
                        Profile
                    </a>
                    <a href="logout.php" class="btn btn-sm btn-accent">
                        Logout
                    </a>
                </li>

            </ul>
        </li>
        <?php endif; ?>

    </ul>
</nav>
