<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<style>
body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
h2 { text-align:center; margin-bottom:20px; }
table { width:100%; border-collapse:collapse; margin-bottom:20px; }
th,td { border:1px solid #000; padding:5px; text-align:right; }
th:first-child,td:first-child { text-align:left; }
tfoot td { font-weight:bold; }
</style>
</head>
<body>
<h2><?= $title ?> Report</h2>
<table>
<thead>
<tr><th>Account Code</th><th>Account Name</th><th>Debit</th><th>Credit</th></tr>
</thead>
<tbody>
<?php foreach($data as $row): ?>
<tr>
  <td><?= htmlspecialchars($row['account_code']) ?></td>
  <td><?= htmlspecialchars($row['account_name']) ?></td>
  <td><?= number_format($row['total_debit'],2) ?></td>
  <td><?= number_format($row['total_credit'],2) ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
</body>
</html>
