<?php
$companyName = $company['name'] ?? 'SGAccount Pte Ltd';
$logoPath = $company['logo_path'] ?? (__DIR__ . '/../../../assets/img/logo.png');
$reportTitle = $title ?? 'Financial Report';
$generatedOn = date('d M Y, h:i A');
$periodLabel = '';

if (isset($_GET['start'], $_GET['end']) && $_GET['start'] && $_GET['end']) {
    $periodLabel = "Period: " . date('d M Y', strtotime($_GET['start'])) . " - " . date('d M Y', strtotime($_GET['end']));
} elseif (isset($_GET['as_of']) && $_GET['as_of']) {
    $periodLabel = "As of: " . date('d M Y', strtotime($_GET['as_of']));
}
?>
<table width="100%" style="border-bottom:2px solid #000;margin-bottom:15px;">
<tr>
    <td width="15%" align="left">
        <?php if (file_exists($logoPath)): ?>
            <img src="<?= $logoPath ?>" style="height:60px;">
        <?php endif; ?>
    </td>
    <td width="70%" align="center">
        <h2 style="margin:0;"><?= htmlspecialchars($companyName) ?></h2>
        <p style="margin:0;font-size:14px;">Home Renovation Accounting System</p>
        <h3 style="margin:10px 0 0;"><?= htmlspecialchars($reportTitle) ?></h3>
        <?php if ($periodLabel): ?>
        <p style="margin:0;font-size:13px;"><?= $periodLabel ?></p>
        <?php endif; ?>
    </td>
    <td width="15%" align="right">
        <p style="font-size:11px;">Generated: <?= $generatedOn ?></p>
    </td>
</tr>
</table>
