<?php
declare(strict_types=1);
require_once __DIR__ . '/../../../app/Config/config.php';
require_once __DIR__ . '/../../../app/Models/Bank.php';
require_once __DIR__ . '/../../../app/Config/functions.php';

require_login();
header('Content-Type: application/json');

try {
    $id = (int)($_POST['id'] ?? 0);
    $state = ($_POST['state'] ?? 'false') === 'true';
    if ($id <= 0) throw new Exception('Invalid transaction ID.');

    $model = new Bank();
    $success = $model->reconcile($id, $state);

    echo json_encode(['status' => $success ? 'success' : 'error', 'message' => $success ? 'Reconciliation updated.' : 'Failed to update.']);
} catch (Throwable $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
