<!-- Add Vendor Modal -->
<div class="modal fade" id="addVendorModal" tabindex="-1" aria-labelledby="addVendorLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title"><i class="fas fa-plus-circle mr-2"></i>Add New Vendor</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <form id="addVendorForm">
        <div class="modal-body">
          <div class="form-row">
            <div class="form-group col-md-6">
              <label>Vendor Name</label>
              <input type="text" name="name" class="form-control" required>
            </div>
            <div class="form-group col-md-6">
              <label>Contact Person</label>
              <input type="text" name="contact_person" class="form-control">
            </div>
          </div>
          <div class="form-row">
            <div class="form-group col-md-6">
              <label>Phone</label>
              <input type="text" name="phone" class="form-control">
            </div>
            <div class="form-group col-md-6">
              <label>Email</label>
              <input type="email" name="email" class="form-control">
            </div>
          </div>
          <div class="form-group">
            <label>Address</label>
            <textarea name="address" rows="2" class="form-control"></textarea>
          </div>
          <div class="form-group">
            <label>GST No</label>
            <input type="text" name="gst_no" class="form-control">
          </div>
        </div>
        <div class="modal-footer bg-light">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary"><i class="fas fa-save mr-1"></i>Save Vendor</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
$('#addVendorForm').on('submit', function(e){
  e.preventDefault();
  $.post('public/ajax/vendor/add.php', $(this).serialize(), function(r){
    alert(r.message);
    if(r.status==='success') location.reload();
  }, 'json');
});
</script>
