<?php
require_once __DIR__ . '/../../Config/functions.php';
require_login();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Vendors | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
<!-- Custom CSS -->
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h1><i class="fas fa-truck mr-2"></i> Vendors</h1>
    <button class="btn btn-primary" data-toggle="modal" data-target="#addVendorModal">
      <i class="fas fa-plus"></i> Add Vendor
    </button>
  </section>

  <section class="content mt-3">
    <div class="card">
      <div class="card-body table-responsive">
        <table id="vendorTable" class="table table-bordered table-striped">
          <thead class="bg-light">
            <tr>
              <th>Name</th>
              <th>Contact Person</th>
              <th>Phone</th>
              <th>Email</th>
              <th>GST No</th>
              <th>Status</th>
              <th style="width: 120px;">Action</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($vendors as $v): ?>
              <tr>
                <td><?= htmlspecialchars($v['name']) ?></td>
                <td><?= htmlspecialchars($v['contact_person']) ?></td>
                <td><?= htmlspecialchars($v['phone']) ?></td>
                <td><?= htmlspecialchars($v['email']) ?></td>
                <td><?= htmlspecialchars($v['gst_no']) ?></td>
                <td>
                  <span class="badge badge-<?= $v['status']=='active'?'success':'secondary' ?>">
                    <?= ucfirst($v['status']) ?>
                  </span>
                </td>
                <td>
                  <button class="btn btn-sm btn-warning text-white editVendorBtn"
                          data-vendor='<?= json_encode($v) ?>'>
                    <i class="fas fa-edit"></i>
                  </button>
                  <button class="btn btn-sm btn-danger deleteVendorBtn" data-id="<?= $v['id'] ?>">
                    <i class="fas fa-trash"></i>
                  </button>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </section>
</div>

<?php include __DIR__ . '/modal-add.php'; ?>
<?php include __DIR__ . '/modal-edit.php'; ?>
<?php include __DIR__ . '/modal-delete.php'; ?>
<?php include __DIR__ . '/../layouts/footer.php'; ?>

</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>

<script>
$(function() {
  $('#vendorTable').DataTable({
    responsive: true,
    pageLength: 10,
    order: [[0, 'asc']]
  });

  // Edit Vendor
  $('.editVendorBtn').on('click', function() {
    const v = $(this).data('vendor');
    $('#editVendorId').val(v.id);
    $('#editVendorName').val(v.name);
    $('#editContactPerson').val(v.contact_person);
    $('#editVendorPhone').val(v.phone);
    $('#editVendorEmail').val(v.email);
    $('#editVendorAddress').val(v.address);
    $('#editVendorGst').val(v.gst_no);
    $('#editVendorModal').modal('show');
  });

  // Delete Vendor
  $('.deleteVendorBtn').on('click', function() {
    const id = $(this).data('id');
    $('#deleteVendorId').val(id);
    $('#deleteVendorModal').modal('show');
  });
});
</script>
</body>
</html>
