<?php
declare(strict_types=1);
require_once __DIR__ . '/../../../app/Models/Setting.php';
require_once __DIR__ . '/../../../app/Config/functions.php';

require_login();
require_role('admin');

header('Content-Type: application/json');
$model = new Setting();

$updated = true;
foreach ($_POST as $key => $value) {
    if (!$model->update($key, trim($value))) {
        $updated = false;
    }
}

echo json_encode([
    'success' => $updated,
    'message' => $updated ? 'Settings updated successfully.' : 'Failed to update settings.'
]);
