<?php
require_once __DIR__ . '/../../Config/functions.php';
require_login();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>System Settings | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h1><i class="fas fa-cogs mr-2"></i> System Settings</h1>
    <button class="btn btn-primary" data-toggle="modal" data-target="#editSettingsModal">
      <i class="fas fa-edit"></i> Edit Settings
    </button>
  </section>

  <section class="content mt-3">
    <div class="card shadow-sm">
      <div class="card-body">
        <table class="table table-striped">
          <tbody>
            <tr><th>Company Name</th><td><?= htmlspecialchars($settings['company_name'] ?? 'SGAccount') ?></td></tr>
            <tr><th>Default Currency</th><td><?= htmlspecialchars($settings['default_currency'] ?? 'SGD') ?></td></tr>
            <tr><th>Financial Year Start</th><td><?= htmlspecialchars($settings['financial_year_start'] ?? '2025-01-01') ?></td></tr>
            <tr><th>GST Rate (%)</th><td><?= htmlspecialchars($settings['gst_rate'] ?? '8.00') ?></td></tr>
            <tr><th>Theme</th><td><?= htmlspecialchars(ucfirst($settings['theme'] ?? 'Light')) ?></td></tr>
          </tbody>
        </table>

        <div class="mt-4 text-center">
          <button class="btn btn-secondary" id="resetBtn">
            <i class="fas fa-sync-alt"></i> Reset to Default
          </button>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include __DIR__ . '/modal-edit.php'; ?>
<?php include __DIR__ . '/../layouts/footer.php'; ?>

</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
$('#resetBtn').on('click', function() {
  if (confirm('Reset all settings to default values?')) {
    $.post('public/ajax/settings/reset.php', function(resp) {
      alert(resp.message);
      location.reload();
    }, 'json');
  }
});
</script>
</body>
</html>
